/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.sensors.SoTimerSensor;

public class SoFileSensor
extends SoTimerSensor {
    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoFileSensor.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void addFileImpl(long var0, String var2);

    private static native void clearFilesImpl(long var0);

    private static native String getFilenameImpl(long var0);

    private static native void removeFileImpl(long var0, String var2);

    private static native long ctorImpl();

    protected SoFileSensor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void addFile(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFileSensor.addFileImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeFile(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFileSensor.removeFileImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void clearFiles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoFileSensor.clearFilesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getFilename() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoFileSensor.getFilenameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoFileSensor() {
        this(Inventor.ConstructorCommand.CreateInstance, SoFileSensor.ctorImplSync());
    }
}

