/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.sensors.SoDataSensor;

public class SoPathSensor
extends SoDataSensor {
    public SoPathSensor(Runnable runnable) {
        this();
        this.setTask(runnable);
    }

    private static native void attachImpl(long var0, long var2);

    private static native long getAttachedPathImpl(long var0);

    private static native void detachImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoPathSensor.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    protected SoPathSensor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void detach() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPathSensor.detachImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoPathSensor() {
        this(Inventor.ConstructorCommand.CreateInstance, SoPathSensor.ctorImplSync());
    }

    public SoPath getAttachedPath() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, SoPathSensor.getAttachedPathImpl(this.getNativeResourceHandle()));
            return soPath;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void attach(SoPath soPath) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoPathSensor.attachImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

