/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.SoDB;
import java.lang.reflect.Method;

public class SoSystemTimerTask
extends Inventor
implements SafeDisposable {
    private static boolean isMainThreadIdReset = false;

    private static void onRun() {
        if (!isMainThreadIdReset) {
            isMainThreadIdReset = true;
            SoSystemTimerTask.callInitGuiThread();
        }
    }

    private static void callInitGuiThread() {
        try {
            Method method = SoDB.class.getDeclaredMethod("initGuiThread", new Class[0]);
            ObjectManager.helperFor(SoDB.class).invokeMethod(method, null, null);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    private static native void runImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    protected SoSystemTimerTask(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    public void run() {
        SoSystemTimerTask.onRun();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSystemTimerTask.runImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

