/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.sensors;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.sensors.SoTimerQueueSensor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SoTimerSensor
extends SoTimerQueueSensor {
    protected TimerSensorTask timerTask = null;
    protected Timer swingTimer = null;
    protected long period_msec = 0L;
    protected boolean isScheduled = false;
    protected long triggerDate = 0L;

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoTimerSensor.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    public SoTimerSensor() {
        this(SoTimerSensor.isTimerSensorWrapped() ? Inventor.ConstructorCommand.CreateInstance : Inventor.ConstructorCommand.DontCreateInstance, SoTimerSensor.isTimerSensorWrapped() ? SoTimerSensor.ctorImplSync() : 0L);
    }

    public SoTimerSensor(Runnable runnable) {
        this();
        this.setTask(runnable);
    }

    @Override
    @Deprecated
    public void setDelay(long l) {
        if (SoTimerSensor.isTimerSensorWrapped()) {
            SbTime sbTime = new SbTime();
            sbTime.setMsecValue(l);
            this.setBaseTime(SoDB.getCurrentTime().plus(sbTime));
        } else {
            this.delay_msec = l;
        }
    }

    @Deprecated
    public void setMsecInterval(long l) {
        if (SoTimerSensor.isTimerSensorWrapped()) {
            SbTime sbTime = new SbTime();
            sbTime.setMsecValue(l);
            this.setInterval(sbTime);
        } else {
            this.period_msec = Math.max(1L, l);
        }
        if (this.isScheduled) {
            this.schedule();
        }
    }

    @Deprecated
    public long getMsecInterval() {
        if (SoTimerSensor.isTimerSensorWrapped()) {
            return this.getInterval().getMsecValue();
        }
        return this.period_msec;
    }

    private boolean onSetBaseTime(SbTime sbTime) {
        if (!SoTimerSensor.isTimerSensorWrapped()) {
            this.delay_msec = sbTime.getMsecValue();
            return true;
        }
        return false;
    }

    private boolean onSetInterval(SbTime sbTime) {
        if (!SoTimerSensor.isTimerSensorWrapped()) {
            this.period_msec = Math.max(1L, sbTime.getMsecValue());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule() {
        if (SoTimerSensor.isTimerSensorWrapped()) {
            super.schedule();
        } else {
            this.unschedule();
            Object object = this.lock;
            synchronized (object) {
                this.triggerDate = System.currentTimeMillis() + this.delay_msec;
                this.timerTask = new TimerSensorTask();
                this.swingTimer = new Timer((int)this.delay_msec, this.timerTask);
                this.swingTimer.setDelay((int)this.period_msec);
                this.swingTimer.start();
                this.isScheduled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unschedule() {
        if (SoTimerSensor.isTimerSensorWrapped()) {
            super.unschedule();
        } else {
            if (!this.isScheduled) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.swingTimer.stop();
                this.isScheduled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isScheduled() {
        if (SoTimerSensor.isTimerSensorWrapped()) {
            return super.isScheduled();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.isScheduled;
        }
    }

    @Override
    public SbTime getTriggerTime() {
        if (SoTimerSensor.isTimerSensorWrapped()) {
            return super.getTriggerTime();
        }
        if (this.isScheduled) {
            return new SbTime(0.001 * (double)this.triggerDate);
        }
        return null;
    }

    private static native void setBaseTimeImpl(long var0, long var2);

    private static native void setIntervalImpl(long var0, long var2);

    private static native void getIntervalImpl(long var0, long var2);

    private static native void getBaseTimeImpl(long var0, long var2);

    protected SoTimerSensor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SbTime getBaseTime() {
        if (!SoTimerSensor.isTimerSensorWrapped()) {
            return new SbTime(0.001 * (double)this.delay_msec);
        }
        SbTime sbTime = new SbTime();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTimerSensor.getBaseTimeImpl(this.getNativeResourceHandle(), sbTime.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbTime;
    }

    public void setInterval(SbTime sbTime) {
        if (this.onSetInterval(sbTime)) {
            return;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTimerSensor.setIntervalImpl(this.getNativeResourceHandle(), sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setBaseTime(SbTime sbTime) {
        if (this.onSetBaseTime(sbTime)) {
            return;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTimerSensor.setBaseTimeImpl(this.getNativeResourceHandle(), sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbTime getInterval() {
        if (!SoTimerSensor.isTimerSensorWrapped()) {
            return new SbTime(0.001 * (double)this.period_msec);
        }
        SbTime sbTime = new SbTime();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTimerSensor.getIntervalImpl(this.getNativeResourceHandle(), sbTime.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbTime;
    }

    class TimerSensorTask
    implements ActionListener {
        TimerSensorTask() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SoTimerSensor.this.task == null) {
                return;
            }
            SoTimerSensor.this.task.run();
            SoTimerSensor.this.triggerDate = System.currentTimeMillis() + SoTimerSensor.this.period_msec;
        }
    }
}

