/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.simplifier;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.nodes.SoNode;

public class SoSimplifier
extends Inventor {
    @Deprecated
    public static final int TRIANGLES = ShapeTypes.access$000();
    @Deprecated
    public static final int TRIANGLE_STRIP = ShapeTypes.access$100();
    @Deprecated
    public static final int TRIANGLE_FAN = ShapeTypes.access$200();

    private static native void setVertexImpl(long var0, float[] var2);

    private static native long simplifyImpl(long var0, float var2);

    private static native void setColorImpl(long var0, long var2);

    private static native void setDataImpl(long var0, int var2, float[] var3);

    private static native void setNormalImpl(long var0, float[] var2);

    private static native void endShapeImpl(long var0);

    private static native void setVerbosityImpl(long var0, boolean var2);

    private static native boolean getVerbosityImpl(long var0);

    private static native int getNumTrianglesImpl(long var0);

    private static native void clearImpl(long var0);

    private static native void beginShapeImpl(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoSimplifier(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void beginShape(ShapeTypes shapeTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.beginShapeImpl(this.getNativeResourceHandle(), shapeTypes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setVerbosity(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.setVerbosityImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setColor(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.setColorImpl(this.getNativeResourceHandle(), l);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getVerbosity() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoSimplifier.getVerbosityImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumTriangles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoSimplifier.getNumTrianglesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode simplify(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoSimplifier.simplifyImpl(this.getNativeResourceHandle(), f));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setNormal(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.setNormalImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setData(int n, float[] fArray) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.setDataImpl(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void endShape() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.endShapeImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void clear() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.clearImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setVertex(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSimplifier.setVertexImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum ShapeTypes implements IntegerValuedEnum
    {
        TRIANGLES(ShapeTypes.getTRIANGLES()),
        TRIANGLE_STRIP(ShapeTypes.getTRIANGLESTRIP()),
        TRIANGLE_FAN(ShapeTypes.getTRIANGLEFAN());

        private int value;

        private static native int getTRIANGLEFAN();

        private ShapeTypes(int n2) {
            this.value = n2;
        }

        private static native int getTRIANGLES();

        private static native int getTRIANGLESTRIP();

        @Deprecated
        public static ShapeTypes fromValue(int n) {
            return ShapeTypes.valueOf(n);
        }

        public static ShapeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ShapeTypes.getTRIANGLES();
        }

        static /* synthetic */ int access$100() {
            return ShapeTypes.getTRIANGLESTRIP();
        }

        static /* synthetic */ int access$200() {
            return ShapeTypes.getTRIANGLEFAN();
        }
    }
}

