/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.touch;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbTime;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.gestures.recognizers.SoGestureRecognizer;
import com.openinventor.inventor.touch.events.SoTouchEvent;
import java.util.ArrayList;
import java.util.Vector;

public class SoTouchManager
extends Inventor {
    private Vector<SoGestureRecognizer> m_recognizerReferences = new Vector();

    private static native void addRecognizerImpl(long var0, long var2);

    private static native void removeRecognizerImpl(long var0, long var2);

    public void addRecognizer(SoGestureRecognizer soGestureRecognizer) {
        if (soGestureRecognizer != null) {
            this.m_recognizerReferences.add(soGestureRecognizer);
        }
        ObjectManager.globalLock.lock();
        try {
            SoTouchManager.addRecognizerImpl(this.getNativeResourceHandle(), soGestureRecognizer != null ? soGestureRecognizer.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void removeRecognizer(SoGestureRecognizer soGestureRecognizer) {
        this.m_recognizerReferences.remove(soGestureRecognizer);
        ObjectManager.globalLock.lock();
        try {
            SoTouchManager.removeRecognizerImpl(this.getNativeResourceHandle(), soGestureRecognizer != null ? soGestureRecognizer.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long[] getTouchMoveEventImpl(long var0, long var2, float[] var4, long var5);

    private static native void setThresholdImpl(long var0, float var2);

    private static native long[] getTouchUpEventImpl(long var0, long var2, float[] var4, long var5);

    private static native int getMaxSimultaneousFingersImpl(long var0);

    private static native long ctorImpl1(long var0);

    private static native void setMaxSimultaneousFingersImpl(long var0, int var2);

    private static native long[] getRecognizerListImpl(long var0);

    private static native void removeDefaultRecognizersImpl(long var0);

    private static native void addDefaultRecognizersImpl(long var0);

    private static native float getThresholdImpl(long var0);

    private static native long[] getTouchDownEventImpl(long var0, long var2, float[] var4, long var5);

    private static native boolean isTouchScreenAvailableImpl(long var0);

    private static native long updateAndProcessTouchEventImpl(long var0, long var2, int var4, float[] var5, long var6);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoTouchManager.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getEventByIdImpl(long var0, long var2);

    private static long ctorImpl1Sync(SoSceneManager soSceneManager) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoTouchManager.ctorImpl1(soSceneManager != null ? soSceneManager.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void setTouchScreenAvailabilityImpl(long var0, boolean var2);

    private static native long ctorImpl();

    private static native int getFingerNumberImpl(long var0);

    private static native long[] getAllFingerIdsImpl(long var0);

    private static native long getEventbyIndexImpl(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoTouchManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public SoTouchEvent updateAndProcessTouchEvent(long l, SoTouchEvent.States states, SbVec2f sbVec2f, SbTime sbTime) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchEvent soTouchEvent = ObjectManager.getManagedObjectFor(SoTouchEvent.class, SoTouchManager.updateAndProcessTouchEventImpl(this.getNativeResourceHandle(), l, states.getValue(), sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soTouchEvent;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxSimultaneousFingers() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoTouchManager.getMaxSimultaneousFingersImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public SoTouchManager(SoSceneManager soSceneManager) {
        this(Inventor.ConstructorCommand.CreateInstance, SoTouchManager.ctorImpl1Sync(soSceneManager));
    }

    public void setMaxSimultaneousFingers(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchManager.setMaxSimultaneousFingersImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getFingerNumber() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoTouchManager.getFingerNumberImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoTouchEvent getEventById(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchEvent soTouchEvent = ObjectManager.getManagedObjectFor(SoTouchEvent.class, SoTouchManager.getEventByIdImpl(this.getNativeResourceHandle(), l));
            return soTouchEvent;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoTouchManager() {
        this(Inventor.ConstructorCommand.CreateInstance, SoTouchManager.ctorImplSync());
    }

    public long[] getAllFingerIds() {
        long[] lArray = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            lArray = SoTouchManager.getAllFingerIdsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return lArray;
    }

    public SoTouchEvent getEventbyIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchEvent soTouchEvent = ObjectManager.getManagedObjectFor(SoTouchEvent.class, SoTouchManager.getEventbyIndexImpl(this.getNativeResourceHandle(), n));
            return soTouchEvent;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setTouchScreenAvailability(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchManager.setTouchScreenAvailabilityImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SoEvent> getTouchDownEvent(long l, SbVec2f sbVec2f, SbTime sbTime) {
        long[] lArray = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            lArray = SoTouchManager.getTouchDownEventImpl(this.getNativeResourceHandle(), l, sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoEvent> arrayList = new ArrayList<SoEvent>(lArray.length);
        for (long l2 : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoEvent.class, l2));
        }
        return arrayList;
    }

    public ArrayList<SoGestureRecognizer> getRecognizerList() {
        long[] lArray = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            lArray = SoTouchManager.getRecognizerListImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoGestureRecognizer> arrayList = new ArrayList<SoGestureRecognizer>(lArray.length);
        for (long l : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoGestureRecognizer.class, l));
        }
        return arrayList;
    }

    public void addDefaultRecognizers() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchManager.addDefaultRecognizersImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeDefaultRecognizers() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchManager.removeDefaultRecognizersImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SoEvent> getTouchMoveEvent(long l, SbVec2f sbVec2f, SbTime sbTime) {
        long[] lArray = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            lArray = SoTouchManager.getTouchMoveEventImpl(this.getNativeResourceHandle(), l, sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoEvent> arrayList = new ArrayList<SoEvent>(lArray.length);
        for (long l2 : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoEvent.class, l2));
        }
        return arrayList;
    }

    public void setThreshold(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchManager.setThresholdImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getThreshold() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoTouchManager.getThresholdImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isTouchScreenAvailable() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoTouchManager.isTouchScreenAvailableImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SoEvent> getTouchUpEvent(long l, SbVec2f sbVec2f, SbTime sbTime) {
        long[] lArray = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            lArray = SoTouchManager.getTouchUpEventImpl(this.getNativeResourceHandle(), l, sbVec2f != null ? sbVec2f.array : null, sbTime != null ? sbTime.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        ArrayList<SoEvent> arrayList = new ArrayList<SoEvent>(lArray.length);
        for (long l2 : lArray) {
            arrayList.add(ObjectManager.getManagedObjectFor(SoEvent.class, l2));
        }
        return arrayList;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

