/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.nodes.SoNode;

public interface SiRenderArea {
    @Deprecated
    public static final int NONE = ClearPolicies.access$000();
    @Deprecated
    public static final int COLORBUFFER = ClearPolicies.access$100();
    @Deprecated
    public static final int DEPTHBUFFER = ClearPolicies.access$200();
    @Deprecated
    public static final int COLORBUFFER_AND_DEPTHBUFFER = ClearPolicies.access$300();
    @Deprecated
    public static final int ABORTED = RenderStatus.access$400();
    @Deprecated
    public static final int INTERACTIVE = RenderStatus.access$500();
    @Deprecated
    public static final int STILL = RenderStatus.access$600();

    public SbEventHandler<RenderEventArg> onStartRender();

    public void setClearPolicy(ClearPolicies var1);

    public SbVec2i32 getSize();

    public RenderStatus render();

    public void setSceneGraph(SoNode var1);

    public SoNode getSceneGraph();

    public float getClearDepth();

    public SbColorRGBA getClearColor();

    public void setClearDepth(float var1);

    public ClearPolicies getClearPolicy();

    public void setSize(SbVec2i32 var1);

    public void setClearColor(SbColorRGBA var1);

    public static class RenderEventArg
    extends Inventor
    implements SbEventArg {
        private static native long ctorImpl(long var0);

        private static native SiRenderArea getSourceImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected RenderEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        public SiRenderArea getSource() {
            return RenderEventArg.getSourceImpl(this.getNativeResourceHandle());
        }

        public void setValue(RenderEventArg renderEventArg) {
            RenderEventArg.setValueImpl(this.getNativeResourceHandle(), renderEventArg.getNativeResourceHandle());
        }

        public RenderEventArg(SiRenderArea siRenderArea) {
            this(Inventor.ConstructorCommand.CreateInstance, RenderEventArg.ctorImpl(siRenderArea != null ? ((Inventor)((Object)siRenderArea)).getNativeResourceHandle() : Inventor.ZeroHandle));
            if (!Inventor.class.isAssignableFrom(siRenderArea.getClass())) {
                throw new UnsupportedOperationException();
            }
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static enum RenderStatus implements IntegerValuedEnum
    {
        ABORTED(RenderStatus.getABORTED()),
        INTERACTIVE(RenderStatus.getINTERACTIVE()),
        STILL(RenderStatus.getSTILL());

        private int value;

        private static native int getSTILL();

        private RenderStatus(int n2) {
            this.value = n2;
        }

        private static native int getABORTED();

        private static native int getINTERACTIVE();

        @Deprecated
        public static RenderStatus fromValue(int n) {
            return RenderStatus.valueOf(n);
        }

        public static RenderStatus valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(RenderStatus.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$400() {
            return RenderStatus.getABORTED();
        }

        static /* synthetic */ int access$500() {
            return RenderStatus.getINTERACTIVE();
        }

        static /* synthetic */ int access$600() {
            return RenderStatus.getSTILL();
        }
    }

    public static enum ClearPolicies implements IntegerValuedEnum
    {
        NONE(ClearPolicies.getNONE()),
        COLORBUFFER(ClearPolicies.getCOLORBUFFER()),
        DEPTHBUFFER(ClearPolicies.getDEPTHBUFFER()),
        COLORBUFFER_AND_DEPTHBUFFER(ClearPolicies.getCOLORBUFFERANDDEPTHBUFFER());

        private int value;

        private static native int getCOLORBUFFERANDDEPTHBUFFER();

        private ClearPolicies(int n2) {
            this.value = n2;
        }

        private static native int getDEPTHBUFFER();

        private static native int getNONE();

        private static native int getCOLORBUFFER();

        @Deprecated
        public static ClearPolicies fromValue(int n) {
            return ClearPolicies.valueOf(n);
        }

        public static ClearPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ClearPolicies.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ClearPolicies.getNONE();
        }

        static /* synthetic */ int access$100() {
            return ClearPolicies.getCOLORBUFFER();
        }

        static /* synthetic */ int access$200() {
            return ClearPolicies.getDEPTHBUFFER();
        }

        static /* synthetic */ int access$300() {
            return ClearPolicies.getCOLORBUFFERANDDEPTHBUFFER();
        }
    }
}

