/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoNode;

public class SoCameraInteractor
extends Inventor
implements SafeDisposable {
    private static native void projectToScreenImpl(long var0, float[] var2, long var3, float[] var5);

    private static native void pivotImpl(long var0, float var2);

    private static native void adjustClippingPlanesImpl(long var0, long var2, long var4);

    private static native void rotateImpl(long var0, float[] var2);

    private static native void projectToPlaneImpl(long var0, float[] var2, float var3, long var4, float[] var6);

    private static native void tiltImpl(long var0, float var2);

    private static native void dollyInWindowImpl(long var0, float[] var2, float[] var3, long var4);

    private static native void lookAtImpl(long var0, float[] var2, float[] var3, float[] var4, float[] var5);

    private static native void dollyWithZoomCenterImpl(long var0, float[] var2, float var3, long var4);

    private static native void rollImpl(long var0, float var2);

    private static native void zoomInWindowImpl(long var0, float[] var2, float[] var3, long var4);

    private static native void getDirectionVectorImpl(long var0, float[] var2);

    private static native void viewInImpl(long var0, float[] var2);

    private static native void rotateImpl1(long var0, float var2);

    private static native void viewInImpl1(long var0, long var2, long var4);

    private static native void viewXImpl(long var0, boolean var2);

    private static native void viewZImpl(long var0, boolean var2);

    private static native void viewAxisImpl(long var0, float[] var2, float[] var3);

    private static native void viewAllImpl(long var0, long var2, long var4);

    private static native void setOrientationImpl(long var0, float[] var2);

    private static native void viewAllImpl1(long var0, long var2, long var4);

    private static native void setRotationAxisImpl(long var0, float[] var2);

    private static native void viewInImpl2(long var0, long var2, long var4);

    private static native void setRotationCenterImpl(long var0, float[] var2);

    private static native void pointAtImpl(long var0, float[] var2);

    private static native void changeViewVolumeImpl(long var0, float var2, float var3);

    private static native long getNewInstanceImpl(long var0);

    private static native void synchronizeImpl(long var0, long var2);

    private static native boolean popCameraImpl(long var0);

    private static native long getCameraImpl(long var0);

    private static native void dollyImpl(long var0, float var2);

    private static native long ctorImpl(long var0);

    private static native void viewYImpl(long var0, boolean var2);

    private static long ctorImplSync(SoCamera soCamera) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoCameraInteractor.ctorImpl(soCamera != null ? soCamera.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void zoomImpl(long var0, float var2);

    private static native void getViewportCenterImpl(long var0, float[] var2);

    private static native void translateImpl(long var0, float[] var2);

    private static native void activateOrbitingImpl(long var0, float[] var2);

    private static native void panImpl(long var0, float[] var2, long var3);

    private static native void activatePanningImpl(long var0, float[] var2, long var3);

    private static native void translateImpl1(long var0, float[] var2, long var3);

    private static native void setPositionImpl1(long var0, float[] var2, float var3, long var4);

    private static native void getFocalPointImpl(long var0, float[] var2);

    private static native void pushCameraImpl(long var0);

    private static native void orbitImpl1(long var0, float[] var2);

    private static native void orbitImpl(long var0, float[] var2);

    private static native void setPositionImpl(long var0, float[] var2);

    protected SoCameraInteractor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    public void viewZ() {
        this.viewZ(false);
    }

    public void viewY() {
        this.viewY(false);
    }

    public void viewX() {
        this.viewX(false);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPosition(SbVec2f sbVec2f, float f, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.setPositionImpl1(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, f, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void orbit(SbRotation sbRotation) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.orbitImpl(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void orbit(SbVec2f sbVec2f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.orbitImpl1(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pushCamera() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.pushCameraImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPosition(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.setPositionImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pan(SbVec2f sbVec2f, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.panImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pointAt(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.pointAtImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void translate(SbVec2f sbVec2f, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.translateImpl1(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void translate(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.translateImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void activateOrbiting(SbVec2f sbVec2f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.activateOrbitingImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f getFocalPoint() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.getFocalPointImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public void dolly(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.dollyImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void changeViewVolume(float f, float f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.changeViewVolumeImpl(this.getNativeResourceHandle(), f, f2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void zoom(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.zoomImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewY(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewYImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoCameraInteractor(SoCamera soCamera) {
        this(Inventor.ConstructorCommand.CreateInstance, SoCameraInteractor.ctorImplSync(soCamera));
    }

    @Deprecated
    public SbVec3f getViewportCenter() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.getViewportCenterImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public boolean popCamera() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoCameraInteractor.popCameraImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void synchronize(SoCamera soCamera) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.synchronizeImpl(this.getNativeResourceHandle(), soCamera != null ? soCamera.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoCameraInteractor getNewInstance(SoCamera soCamera) {
        ObjectManager.globalLock.lock();
        try {
            SoCameraInteractor soCameraInteractor = ObjectManager.getManagedObjectFor(SoCameraInteractor.class, SoCameraInteractor.getNewInstanceImpl(soCamera != null ? soCamera.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soCameraInteractor;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoCamera getCamera() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCamera soCamera = ObjectManager.getManagedObjectFor(SoCamera.class, SoCameraInteractor.getCameraImpl(this.getNativeResourceHandle()));
            return soCamera;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewAll(SoPath soPath, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewAllImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRotationAxis(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.setRotationAxisImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewIn(SoNode soNode, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewInImpl2(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setOrientation(SbRotation sbRotation) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.setOrientationImpl(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewAll(SoNode soNode, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewAllImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRotationCenter(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.setRotationCenterImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewIn(SbBox3f sbBox3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewInImpl(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewX(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewXImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewZ(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewZImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void rotate(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.rotateImpl1(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewIn(SoPath soPath, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewInImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void viewAxis(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.viewAxisImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3f projectToPlane(SbVec2f sbVec2f, float f, SbViewportRegion sbViewportRegion) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.projectToPlaneImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, f, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SbVec3f getDirectionVector() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.getDirectionVectorImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dollyInWindow(SbVec2f sbVec2f, SbVec2f sbVec2f2, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.dollyInWindowImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, sbVec2f2 != null ? sbVec2f2.array : null, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void roll(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.rollImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void activatePanning(SbVec2f sbVec2f, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.activatePanningImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbRotation lookAt(SbVec3f sbVec3f, SbVec3f sbVec3f2, SbVec3f sbVec3f3) {
        SbRotation sbRotation = new SbRotation();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.lookAtImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbVec3f3 != null ? sbVec3f3.array : null, sbRotation.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dollyWithZoomCenter(SbVec2f sbVec2f, float f, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.dollyWithZoomCenterImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, f, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void tilt(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.tiltImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec2f projectToScreen(SbVec3f sbVec3f, SbViewportRegion sbViewportRegion) {
        SbVec2f sbVec2f = new SbVec2f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.projectToScreenImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec2f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2f;
    }

    public void rotate(SbRotation sbRotation) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.rotateImpl(this.getNativeResourceHandle(), sbRotation != null ? sbRotation.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomInWindow(SbVec2f sbVec2f, SbVec2f sbVec2f2, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.zoomInWindowImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, sbVec2f2 != null ? sbVec2f2.array : null, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pivot(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.pivotImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void adjustClippingPlanes(SoNode soNode, SbViewportRegion sbViewportRegion) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoCameraInteractor.adjustClippingPlanesImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

