/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.nodes.SoInteractiveComplexity;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.viewercomponents.SiRenderArea;
import com.openinventor.inventor.viewercomponents.SiRenderAreaAntialiasing;
import com.openinventor.inventor.viewercomponents.SiRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.SiRenderAreaStereo;
import com.openinventor.inventor.viewercomponents.SiRenderAreaStillSuperSampling;
import com.openinventor.inventor.viewercomponents.SiRenderAreaTransparency;
import com.openinventor.inventor.viewercomponents.SoStereoParameters;
import java.util.Collection;

public class SoRenderAreaCore
extends Inventor
implements SiRenderAreaAntialiasing,
SiRenderAreaTransparency,
SiRenderAreaStereo,
SiRenderAreaInteractive,
SiRenderArea,
SiRenderAreaStillSuperSampling,
SafeDisposable {
    private SoNode m_sceneGraph;
    private SoStereoParameters m_parameters_setStereoParameters;
    private final SbEventHandler<SiRenderArea.RenderEventArg> onStartRender;

    private void onSetSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
    }

    @Override
    protected void preMortenClean() {
        super.preMortenClean();
    }

    private static native void invalidateGLContext(long var0);

    private static native void setInteractiveModeImpl(long var0, int var2);

    private static native long addOnStartRenderEventHandler(long var0, OnStartRenderEventHandler var2, String var3);

    private static native float getClearDepthImpl(long var0);

    private static native void setClearDepthImpl(long var0, float var2);

    private static native int getInteractiveModeImpl(long var0);

    private static native void setTransparencyTypeImpl(long var0, int var2);

    private static native void setAntialiasingQualityImpl(long var0, float var2);

    private static native int getTransparencyTypeImpl(long var0);

    private static native long getSceneManagerImpl(long var0);

    private static native boolean removeOnStartRenderEventHandler(long var0, long var2);

    private static native void setStereoParametersImpl(long var0, long var2);

    private static native void setClearPolicyImpl(long var0, int var2);

    private static native boolean isStereoActivatedImpl(long var0);

    private static native void setAntialiasingModeImpl(long var0, int var2);

    private static native int getAntialiasingModeImpl(long var0);

    private static native float getAntialiasingQualityImpl(long var0);

    private static native long getStereoParametersImpl(long var0);

    private static native void getClearColorImpl(long var0, float[] var2);

    private static native void setClearColorImpl(long var0, float[] var2);

    private static native int getClearPolicyImpl(long var0);

    private static native void activateStereoImpl(long var0, boolean var2);

    private static native void getSizeImpl(long var0, int[] var2);

    private static long ctorImplSync(SoGLContext soGLContext) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoRenderAreaCore.ctorImpl(soGLContext != null ? soGLContext.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getSceneGraphImpl(long var0);

    private static native boolean processEventImpl(long var0, long var2);

    private static native void setStillSuperSamplingQualityImpl(long var0, float var2);

    private static native long ctorImpl(long var0);

    private static native void setSceneGraphImpl(long var0, long var2);

    private static native boolean processEventsImpl(long var0, long[] var2);

    private static native int renderImpl(long var0);

    private static native void setStillSuperSamplingDelayImpl(long var0, int var2);

    private static native float getStillSuperSamplingQualityImpl(long var0);

    private static native void setSizeImpl(long var0, int[] var2);

    private static native int getStillSuperSamplingDelayImpl(long var0);

    protected SoRenderAreaCore(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.onStartRender = new OnStartRenderEventHandler();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public SbEventHandler<SiRenderArea.RenderEventArg> onStartRender() {
        return this.onStartRender;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    @Override
    public SbVec2i32 getSize() {
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.getSizeImpl(this.getNativeResourceHandle(), sbVec2i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2i32;
    }

    @Override
    public void setStillSuperSamplingDelay(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setStillSuperSamplingDelayImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setSize(SbVec2i32 sbVec2i32) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setSizeImpl(this.getNativeResourceHandle(), sbVec2i32 != null ? sbVec2i32.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setStillSuperSamplingQuality(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setStillSuperSamplingQualityImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLRenderAction.TransparencyTypes transparencyTypes = IntegerValuedEnumHelper.fromIntValue(SoGLRenderAction.TransparencyTypes.class, SoRenderAreaCore.getTransparencyTypeImpl(this.getNativeResourceHandle()));
            return transparencyTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public float getStillSuperSamplingQuality() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoRenderAreaCore.getStillSuperSamplingQualityImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setTransparencyTypeImpl(this.getNativeResourceHandle(), transparencyTypes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public int getStillSuperSamplingDelay() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoRenderAreaCore.getStillSuperSamplingDelayImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.onSetSceneGraph(soNode);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setSceneGraphImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoRenderAreaCore(SoGLContext soGLContext) {
        this(Inventor.ConstructorCommand.CreateInstance, SoRenderAreaCore.ctorImplSync(soGLContext));
    }

    @Override
    public boolean isStereoActivated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoRenderAreaCore.isStereoActivatedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SoNode getSceneGraph() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoRenderAreaCore.getSceneGraphImpl(this.getNativeResourceHandle()));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SiRenderArea.RenderStatus render() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiRenderArea.RenderStatus renderStatus = IntegerValuedEnumHelper.fromIntValue(SiRenderArea.RenderStatus.class, SoRenderAreaCore.renderImpl(this.getNativeResourceHandle()));
            return renderStatus;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processEvents(Collection<SoEvent> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("eventList cannot be null");
        }
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (SoEvent soEvent : collection) {
            lArray[n++] = soEvent != null ? soEvent.getNativeResourceHandle() : Inventor.ZeroHandle;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoRenderAreaCore.processEventsImpl(this.getNativeResourceHandle(), lArray);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public boolean processEvent(SoEvent soEvent) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoRenderAreaCore.processEventImpl(this.getNativeResourceHandle(), soEvent != null ? soEvent.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoSceneManager getSceneManager() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager soSceneManager = ObjectManager.getManagedObjectFor(SoSceneManager.class, SoRenderAreaCore.getSceneManagerImpl(this.getNativeResourceHandle()));
            return soSceneManager;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setAntialiasingMode(SoSceneManager.AntialiasingModes antialiasingModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setAntialiasingModeImpl(this.getNativeResourceHandle(), antialiasingModes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SiRenderArea.ClearPolicies getClearPolicy() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiRenderArea.ClearPolicies clearPolicies = IntegerValuedEnumHelper.fromIntValue(SiRenderArea.ClearPolicies.class, SoRenderAreaCore.getClearPolicyImpl(this.getNativeResourceHandle()));
            return clearPolicies;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setClearColor(SbColorRGBA sbColorRGBA) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setClearColorImpl(this.getNativeResourceHandle(), sbColorRGBA != null ? sbColorRGBA.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setClearPolicy(SiRenderArea.ClearPolicies clearPolicies) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setClearPolicyImpl(this.getNativeResourceHandle(), clearPolicies.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setAntialiasingQuality(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setAntialiasingQualityImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public float getAntialiasingQuality() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoRenderAreaCore.getAntialiasingQualityImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SoSceneManager.AntialiasingModes getAntialiasingMode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager.AntialiasingModes antialiasingModes = IntegerValuedEnumHelper.fromIntValue(SoSceneManager.AntialiasingModes.class, SoRenderAreaCore.getAntialiasingModeImpl(this.getNativeResourceHandle()));
            return antialiasingModes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void activateStereo(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.activateStereoImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public float getClearDepth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoRenderAreaCore.getClearDepthImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SoInteractiveComplexity.InteractiveModes getInteractiveMode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoInteractiveComplexity.InteractiveModes interactiveModes = IntegerValuedEnumHelper.fromIntValue(SoInteractiveComplexity.InteractiveModes.class, SoRenderAreaCore.getInteractiveModeImpl(this.getNativeResourceHandle()));
            return interactiveModes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setInteractiveMode(SoInteractiveComplexity.InteractiveModes interactiveModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setInteractiveModeImpl(this.getNativeResourceHandle(), interactiveModes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setStereoParameters(SoStereoParameters soStereoParameters) {
        this.m_parameters_setStereoParameters = soStereoParameters;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setStereoParametersImpl(this.getNativeResourceHandle(), soStereoParameters != null ? soStereoParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public SbColorRGBA getClearColor() {
        SbColorRGBA sbColorRGBA = new SbColorRGBA();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.getClearColorImpl(this.getNativeResourceHandle(), sbColorRGBA.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbColorRGBA;
    }

    @Override
    public SoStereoParameters getStereoParameters() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoStereoParameters soStereoParameters = ObjectManager.getManagedObjectFor(SoStereoParameters.class, SoRenderAreaCore.getStereoParametersImpl(this.getNativeResourceHandle()));
            return soStereoParameters;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    public void setClearDepth(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRenderAreaCore.setClearDepthImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private class OnStartRenderEventHandler
    extends SbEventHandler<SiRenderArea.RenderEventArg> {
        private OnStartRenderEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRenderAreaCore.removeOnStartRenderEventHandler(SoRenderAreaCore.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = SiRenderArea.RenderEventArg.class.getName();
            this.m_nativeEventHandler = SoRenderAreaCore.addOnStartRenderEventHandler(SoRenderAreaCore.this.getNativeResourceHandle(), this, string);
        }
    }
}

