/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.vrmlnodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.fields.SoMFFilePathString;
import com.openinventor.inventor.vrmlnodes.SoVRMLTexture;

public class SoVRMLImageTexture
extends SoVRMLTexture {
    @Deprecated
    public static final int UNKNOWN = FileTypes.access$000();
    @Deprecated
    public static final int RGB = FileTypes.access$100();
    @Deprecated
    public static final int SGI = FileTypes.access$200();
    @Deprecated
    public static final int TIFF = FileTypes.access$300();
    @Deprecated
    public static final int GIF = FileTypes.access$400();
    @Deprecated
    public static final int JPEG = FileTypes.access$500();
    @Deprecated
    public static final int BMP = FileTypes.access$600();
    @Deprecated
    public static final int PNG = FileTypes.access$700();
    @Deprecated
    public static final int JPEG2000 = FileTypes.access$800();
    @Deprecated
    public static final int PGX = FileTypes.access$900();
    @Deprecated
    public static final int PNM = FileTypes.access$1000();
    @Deprecated
    public static final int RAS = FileTypes.access$1100();
    @Deprecated
    public static final int DDS = FileTypes.access$1200();
    @Deprecated
    public static final int HDRI = FileTypes.access$1300();
    @Deprecated
    public static final int NUM_FILETYPES = FileTypes.access$1400();
    public final SoMFFilePathString url;

    private static native byte[] getImageImpl(long var0, short[] var2, int[] var3);

    private static native int getBitmapFileTypeImpl(long var0);

    private static native void setBitmapFileTypeImpl(long var0, int var2);

    private static native long ctorImpl();

    private static native void allowPrequalifyFileImpl(long var0, boolean var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRMLImageTexture.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoVRMLImageTexture(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.url = ObjectManager.getManagedObjectFor(SoMFFilePathString.class, SoVRMLImageTexture.getFieldHandle(this.getNativeResourceHandle(), "url"));
    }

    static native String getClassTypeId();

    public FileTypes getBitmapFileType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            FileTypes fileTypes = IntegerValuedEnumHelper.fromIntValue(FileTypes.class, SoVRMLImageTexture.getBitmapFileTypeImpl(this.getNativeResourceHandle()));
            return fileTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureImage getImage() {
        TextureImage textureImage = new TextureImage();
        SbVec2s sbVec2s = new SbVec2s();
        int[] nArray = new int[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            textureImage.buffer = SoVRMLImageTexture.getImageImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null, nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        textureImage.size = sbVec2s;
        textureImage.numcomp = nArray[0];
        return textureImage;
    }

    public void setBitmapFileType(FileTypes fileTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLImageTexture.setBitmapFileTypeImpl(this.getNativeResourceHandle(), fileTypes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void allowPrequalifyFile(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLImageTexture.allowPrequalifyFileImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRMLImageTexture() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRMLImageTexture.ctorImplSync());
    }

    public static class TextureImage {
        public SbVec2s size;
        public int numcomp;
        public byte[] buffer;
    }

    public static enum FileTypes implements IntegerValuedEnum
    {
        UNKNOWN(FileTypes.getUNKNOWN()),
        RGB(FileTypes.getRGB()),
        SGI(FileTypes.getSGI()),
        TIFF(FileTypes.getTIFF()),
        GIF(FileTypes.getGIF()),
        JPEG(FileTypes.getJPEG()),
        BMP(FileTypes.getBMP()),
        PNG(FileTypes.getPNG()),
        JPEG2000(FileTypes.getJPEG2000()),
        PGX(FileTypes.getPGX()),
        PNM(FileTypes.getPNM()),
        RAS(FileTypes.getRAS()),
        DDS(FileTypes.getDDS()),
        HDRI(FileTypes.getHDRI()),
        NUM_FILETYPES(FileTypes.getNUMFILETYPES());

        private int value;

        private static native int getPNM();

        private static native int getRAS();

        private static native int getJPEG2000();

        private static native int getPGX();

        private static native int getNUMFILETYPES();

        private FileTypes(int n2) {
            this.value = n2;
        }

        private static native int getDDS();

        private static native int getHDRI();

        private static native int getSGI();

        private static native int getTIFF();

        private static native int getUNKNOWN();

        private static native int getRGB();

        private static native int getBMP();

        private static native int getPNG();

        private static native int getGIF();

        private static native int getJPEG();

        @Deprecated
        public static FileTypes fromValue(int n) {
            return FileTypes.valueOf(n);
        }

        public static FileTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(FileTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return FileTypes.getUNKNOWN();
        }

        static /* synthetic */ int access$100() {
            return FileTypes.getRGB();
        }

        static /* synthetic */ int access$200() {
            return FileTypes.getSGI();
        }

        static /* synthetic */ int access$300() {
            return FileTypes.getTIFF();
        }

        static /* synthetic */ int access$400() {
            return FileTypes.getGIF();
        }

        static /* synthetic */ int access$500() {
            return FileTypes.getJPEG();
        }

        static /* synthetic */ int access$600() {
            return FileTypes.getBMP();
        }

        static /* synthetic */ int access$700() {
            return FileTypes.getPNG();
        }

        static /* synthetic */ int access$800() {
            return FileTypes.getJPEG2000();
        }

        static /* synthetic */ int access$900() {
            return FileTypes.getPGX();
        }

        static /* synthetic */ int access$1000() {
            return FileTypes.getPNM();
        }

        static /* synthetic */ int access$1100() {
            return FileTypes.getRAS();
        }

        static /* synthetic */ int access$1200() {
            return FileTypes.getDDS();
        }

        static /* synthetic */ int access$1300() {
            return FileTypes.getHDRI();
        }

        static /* synthetic */ int access$1400() {
            return FileTypes.getNUMFILETYPES();
        }
    }
}

