/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.vrmlnodes;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.vrmlnodes.SoVRMLInterpolator;

public class SoVRMLInterpOutput
extends Inventor {
    private static native void enableImpl(long var0, boolean var2);

    private static native boolean isEnabledImpl(long var0);

    private static native String getConnectionTypeImpl(long var0);

    private static native long getContainerImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoVRMLInterpOutput(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public Class<? extends Inventor> getConnectionClass() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Class<? extends Inventor> clazz = NativeTypeMap.getJavaClass(SoVRMLInterpOutput.getConnectionTypeImpl(this.getNativeResourceHandle()));
            return clazz;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enable(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLInterpOutput.enableImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRMLInterpolator getContainer() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLInterpolator soVRMLInterpolator = ObjectManager.getManagedObjectFor(SoVRMLInterpolator.class, SoVRMLInterpOutput.getContainerImpl(this.getNativeResourceHandle()));
            return soVRMLInterpolator;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVRMLInterpOutput.isEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

