/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.vrmlnodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFFloat;
import com.openinventor.inventor.fields.SoMFNode;
import com.openinventor.inventor.fields.SoSFVec3f;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.vrmlnodes.SoVRMLParent;

public class SoVRMLLOD
extends SoVRMLParent {
    public final SoMFFloat range;
    public final SoSFVec3f center;
    public final SoMFNode level;

    private static native int findLevelImpl(long var0, long var2);

    private static native int getNumLevelsImpl(long var0);

    private static native long getLevelImpl(long var0, int var2);

    private static native void insertLevelImpl(long var0, long var2, int var4);

    private static native void removeLevelImpl1(long var0, long var2);

    private static native void removeAllLevelsImpl(long var0);

    private static native void replaceLevelImpl(long var0, int var2, long var3);

    private static native void replaceLevelImpl1(long var0, long var2, long var4);

    private static native void removeLevelImpl(long var0, int var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRMLLOD.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl1(int var0);

    private static native long ctorImpl();

    private static long ctorImpl1Sync(int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRMLLOD.ctorImpl1(n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void addLevelImpl(long var0, long var2);

    protected SoVRMLLOD(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.range = ObjectManager.getManagedObjectFor(SoMFFloat.class, SoVRMLLOD.getFieldHandle(this.getNativeResourceHandle(), "range"));
        this.center = ObjectManager.getManagedObjectFor(SoSFVec3f.class, SoVRMLLOD.getFieldHandle(this.getNativeResourceHandle(), "center"));
        this.level = ObjectManager.getManagedObjectFor(SoMFNode.class, SoVRMLLOD.getFieldHandle(this.getNativeResourceHandle(), "level"));
    }

    static native String getClassTypeId();

    public SoVRMLLOD(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRMLLOD.ctorImpl1Sync(n));
    }

    public void removeAllLevels() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLLOD.removeAllLevelsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void replaceLevel(int n, SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLLOD.replaceLevelImpl(this.getNativeResourceHandle(), n, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRMLLOD() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRMLLOD.ctorImplSync());
    }

    public void addLevel(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLLOD.addLevelImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumLevels() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRMLLOD.getNumLevelsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int findLevel(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRMLLOD.findLevelImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getLevel(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoVRMLLOD.getLevelImpl(this.getNativeResourceHandle(), n));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeLevel(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLLOD.removeLevelImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void insertLevel(SoNode soNode, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLLOD.insertLevelImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeLevel(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLLOD.removeLevelImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void replaceLevel(SoNode soNode, SoNode soNode2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLLOD.replaceLevelImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

