/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.vrmlnodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFNode;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.vrmlnodes.SoVRMLParent;

public class SoVRMLSwitch
extends SoVRMLParent {
    public final SoMFNode choice;
    public final SoSFInt32 whichChoice;

    private static native int findChoiceImpl(long var0, long var2);

    private static native int getNumChoicesImpl(long var0);

    private static native long getChoiceImpl(long var0, int var2);

    private static native void insertChoiceImpl(long var0, long var2, int var4);

    private static native void removeChoiceImpl1(long var0, long var2);

    private static native void removeAllChoicesImpl(long var0);

    private static native void replaceChoiceImpl(long var0, int var2, long var3);

    private static native void replaceChoiceImpl1(long var0, long var2, long var4);

    private static native void removeChoiceImpl(long var0, int var2);

    private static native long ctorImpl1(int var0);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRMLSwitch.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImpl1Sync(int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRMLSwitch.ctorImpl1(n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void addChoiceImpl(long var0, long var2);

    protected SoVRMLSwitch(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.choice = ObjectManager.getManagedObjectFor(SoMFNode.class, SoVRMLSwitch.getFieldHandle(this.getNativeResourceHandle(), "choice"));
        this.whichChoice = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoVRMLSwitch.getFieldHandle(this.getNativeResourceHandle(), "whichChoice"));
    }

    static native String getClassTypeId();

    public SoVRMLSwitch() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRMLSwitch.ctorImplSync());
    }

    public void addChoice(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLSwitch.addChoiceImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRMLSwitch(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRMLSwitch.ctorImpl1Sync(n));
    }

    public void removeAllChoices() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLSwitch.removeAllChoicesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void replaceChoice(SoNode soNode, SoNode soNode2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLSwitch.replaceChoiceImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeChoice(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLSwitch.removeChoiceImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void replaceChoice(int n, SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLSwitch.replaceChoiceImpl(this.getNativeResourceHandle(), n, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeChoice(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLSwitch.removeChoiceImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoNode getChoice(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoNode soNode = ObjectManager.getManagedObjectFor(SoNode.class, SoVRMLSwitch.getChoiceImpl(this.getNativeResourceHandle(), n));
            return soNode;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void insertChoice(SoNode soNode, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLSwitch.insertChoiceImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumChoices() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRMLSwitch.getNumChoicesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int findChoice(SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRMLSwitch.findChoiceImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

