/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.vrmlnodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.fields.SoSFRotation;
import com.openinventor.inventor.fields.SoSFVec3f;
import com.openinventor.inventor.vrmlnodes.SoVRMLGroup;

public class SoVRMLTransform
extends SoVRMLGroup {
    public final SoSFVec3f translation;
    public final SoSFRotation rotation;
    public final SoSFVec3f scale;
    public final SoSFRotation scaleOrientation;
    public final SoSFVec3f center;

    private static native void setMatrixImpl(long var0, float[] var2);

    private static native void getRotationSpaceMatrixImpl(long var0, float[] var2, float[] var3);

    private static native void recenterImpl(long var0, float[] var2);

    private static native void getScaleSpaceMatrixImpl(long var0, float[] var2, float[] var3);

    private static native void getTranslationSpaceMatrixImpl(long var0, float[] var2, float[] var3);

    private static native void combineLeftImpl(long var0, long var2);

    private static native void multRightImpl(long var0, float[] var2);

    private static native void combineRightImpl(long var0, long var2);

    private static native void multLeftImpl(long var0, float[] var2);

    private static native long ctorImpl();

    private static long ctorImpl1Sync(int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRMLTransform.ctorImpl1(n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRMLTransform.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void pointAtImpl(long var0, float[] var2, float[] var3);

    private static native long ctorImpl1(int var0);

    protected SoVRMLTransform(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.translation = ObjectManager.getManagedObjectFor(SoSFVec3f.class, SoVRMLTransform.getFieldHandle(this.getNativeResourceHandle(), "translation"));
        this.rotation = ObjectManager.getManagedObjectFor(SoSFRotation.class, SoVRMLTransform.getFieldHandle(this.getNativeResourceHandle(), "rotation"));
        this.scale = ObjectManager.getManagedObjectFor(SoSFVec3f.class, SoVRMLTransform.getFieldHandle(this.getNativeResourceHandle(), "scale"));
        this.scaleOrientation = ObjectManager.getManagedObjectFor(SoSFRotation.class, SoVRMLTransform.getFieldHandle(this.getNativeResourceHandle(), "scaleOrientation"));
        this.center = ObjectManager.getManagedObjectFor(SoSFVec3f.class, SoVRMLTransform.getFieldHandle(this.getNativeResourceHandle(), "center"));
    }

    static native String getClassTypeId();

    public void setMatrix(SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.setMatrixImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRMLTransform() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRMLTransform.ctorImplSync());
    }

    public SbMatrix[] getTranslationSpaceMatrix() {
        SbMatrix sbMatrix = new SbMatrix();
        SbMatrix sbMatrix2 = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.getTranslationSpaceMatrixImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null, sbMatrix2 != null ? sbMatrix2.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        SbMatrix[] sbMatrixArray = new SbMatrix[]{sbMatrix, sbMatrix2};
        return sbMatrixArray;
    }

    public SbMatrix[] getRotationSpaceMatrix() {
        SbMatrix sbMatrix = new SbMatrix();
        SbMatrix sbMatrix2 = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.getRotationSpaceMatrixImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null, sbMatrix2 != null ? sbMatrix2.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        SbMatrix[] sbMatrixArray = new SbMatrix[]{sbMatrix, sbMatrix2};
        return sbMatrixArray;
    }

    public void multLeft(SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.multLeftImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void multRight(SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.multRightImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void combineRight(SoVRMLTransform soVRMLTransform) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.combineRightImpl(this.getNativeResourceHandle(), soVRMLTransform != null ? soVRMLTransform.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRMLTransform(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRMLTransform.ctorImpl1Sync(n));
    }

    public void combineLeft(SoVRMLTransform soVRMLTransform) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.combineLeftImpl(this.getNativeResourceHandle(), soVRMLTransform != null ? soVRMLTransform.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void pointAt(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.pointAtImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void recenter(SbVec3f sbVec3f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.recenterImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbMatrix[] getScaleSpaceMatrix() {
        SbMatrix sbMatrix = new SbMatrix();
        SbMatrix sbMatrix2 = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRMLTransform.getScaleSpaceMatrixImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null, sbMatrix2 != null ? sbMatrix2.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        SbMatrix[] sbMatrixArray = new SbMatrix[]{sbMatrix, sbMatrix2};
        return sbMatrixArray;
    }
}

