/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.ldm.SoLDMLargeDataManagement;
import com.openinventor.ldm.SoLDMTileVisitor;
import com.openinventor.ldm.nodes.SoROI;

public class SoLDMGeometry
extends SoLDMLargeDataManagement {
    private static native void assignTilePriorityImpl(long var0);

    private static native void addGeometryImpl(long var0, long var2, long var4);

    private static native boolean isTileInROIImpl(long var0, long var2, int[] var4, long var5, boolean var7);

    private static native void endCollectingGeometryImpl(long var0, long var2);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLDMGeometry.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void beginCollectingGeometryImpl(long var0, long var2);

    protected SoLDMGeometry(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void endCollectingGeometry() {
        this.endCollectingGeometry(null);
    }

    public void beginCollectingGeometry() {
        this.beginCollectingGeometry(null);
    }

    public SoLDMGeometry() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMGeometry.ctorImplSync());
    }

    public void assignTilePriority() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMGeometry.assignTilePriorityImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void endCollectingGeometry(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMGeometry.endCollectingGeometryImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addGeometry(SoAction soAction, SoNode soNode) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMGeometry.addGeometryImpl(this.getNativeResourceHandle(), soAction != null ? soAction.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void beginCollectingGeometry(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMGeometry.beginCollectingGeometryImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoLDMTileVisitor.NodeStatus isTileInROI(SoROI soROI, SbBox3i32 sbBox3i32, boolean bl) {
        SoLDMTileVisitor.NodeStatus nodeStatus = new SoLDMTileVisitor.NodeStatus();
        boolean bl2 = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl2 = SoLDMGeometry.isTileInROIImpl(this.getNativeResourceHandle(), soROI != null ? soROI.getNativeResourceHandle() : Inventor.ZeroHandle, sbBox3i32 != null ? sbBox3i32.array : null, nodeStatus != null ? nodeStatus.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl2) {
            return nodeStatus;
        }
        return null;
    }
}

