/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.ldm.SoLDMGeometry;
import com.openinventor.ldm.SoLDMNodeFrontManager;
import com.openinventor.ldm.SoLDMResourceManager;
import com.openinventor.ldm.SoLDMTileManager;
import com.openinventor.ldm.SoLDMTileVisitor;

public class SoLDMMediator
extends Inventor {
    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLDMMediator.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoLDMMediator(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoLDMMediator() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMMediator.ctorImplSync());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static class LDMManagerAccess
    extends Inventor {
        private SoLDMMediator m_mediator_setMediator;
        private SoLDMNodeFrontManager m_name_17574_setNodeFrontManager;
        private SoLDMTileVisitor m_name_17575_setTileVisitor;
        private SoLDMTileManager m_tilemgr_setTileManager;

        private static native boolean isTileVisitorOwnedByUserImpl(long var0);

        private static native void toArrayImpl(long var0, long[] var2);

        private static native void setTileVisitorImpl(long var0, long var2, boolean var4);

        private static native long getTileVisitorImpl(long var0);

        private static native long getResourceManagerImpl(long var0, int var2);

        private static native void setValueImpl(long var0, long var2);

        private static native void setTileManagerImpl(long var0, long var2, boolean var4);

        private static native long getTileManagerImpl(long var0);

        private static native long getNodeFrontManagerImpl(long var0);

        private static native void setMediatorImpl(long var0, long var2);

        private static native void setNodeFrontManagerImpl(long var0, long var2);

        private static native long ctorImpl();

        private static native long getVVizGeometryImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected LDMManagerAccess(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public void setTileManager(SoLDMTileManager soLDMTileManager) {
            this.setTileManager(soLDMTileManager, true);
        }

        public SoLDMResourceManager getResourceManager() {
            return this.getResourceManager(-1);
        }

        @Deprecated
        public void setTileVisitor(SoLDMTileVisitor soLDMTileVisitor) {
            this.setTileVisitor(soLDMTileVisitor, true);
        }

        public LDMManagerAccess(LDMManagerAccess lDMManagerAccess) {
            this();
            this.setValue(lDMManagerAccess);
        }

        @Deprecated
        public void setTileVisitor(SoLDMTileVisitor soLDMTileVisitor, boolean bl) {
            this.m_name_17575_setTileVisitor = soLDMTileVisitor;
            LDMManagerAccess.setTileVisitorImpl(this.getNativeResourceHandle(), soLDMTileVisitor != null ? soLDMTileVisitor.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }

        public SoLDMNodeFrontManager getNodeFrontManager() {
            return ObjectManager.getManagedObjectFor(SoLDMNodeFrontManager.class, LDMManagerAccess.getNodeFrontManagerImpl(this.getNativeResourceHandle()));
        }

        public static LDMManagerAccess[] toArray(long l, long l2) {
            LDMManagerAccess[] lDMManagerAccessArray = new LDMManagerAccess[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                lDMManagerAccessArray[n] = new LDMManagerAccess();
                lArray[n] = lDMManagerAccessArray[n].getNativeResourceHandle();
                ++n;
            }
            LDMManagerAccess.toArrayImpl(l, lArray);
            return lDMManagerAccessArray;
        }

        @Deprecated
        public SoLDMTileVisitor getTileVisitor() {
            return ObjectManager.getManagedObjectFor(SoLDMTileVisitor.class, LDMManagerAccess.getTileVisitorImpl(this.getNativeResourceHandle()));
        }

        public void setValue(LDMManagerAccess lDMManagerAccess) {
            LDMManagerAccess.setValueImpl(this.getNativeResourceHandle(), lDMManagerAccess.getNativeResourceHandle());
        }

        public void setTileManager(SoLDMTileManager soLDMTileManager, boolean bl) {
            this.m_tilemgr_setTileManager = soLDMTileManager;
            LDMManagerAccess.setTileManagerImpl(this.getNativeResourceHandle(), soLDMTileManager != null ? soLDMTileManager.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }

        public void setMediator(SoLDMMediator soLDMMediator) {
            this.m_mediator_setMediator = soLDMMediator;
            LDMManagerAccess.setMediatorImpl(this.getNativeResourceHandle(), soLDMMediator != null ? soLDMMediator.getNativeResourceHandle() : Inventor.ZeroHandle);
        }

        @Deprecated
        public SoLDMGeometry getVVizGeometry() {
            return ObjectManager.getManagedObjectFor(SoLDMGeometry.class, LDMManagerAccess.getVVizGeometryImpl(this.getNativeResourceHandle()));
        }

        public void setNodeFrontManager(SoLDMNodeFrontManager soLDMNodeFrontManager) {
            this.m_name_17574_setNodeFrontManager = soLDMNodeFrontManager;
            LDMManagerAccess.setNodeFrontManagerImpl(this.getNativeResourceHandle(), soLDMNodeFrontManager != null ? soLDMNodeFrontManager.getNativeResourceHandle() : Inventor.ZeroHandle);
        }

        public SoLDMResourceManager getResourceManager(int n) {
            return ObjectManager.getManagedObjectFor(SoLDMResourceManager.class, LDMManagerAccess.getResourceManagerImpl(this.getNativeResourceHandle(), n));
        }

        public LDMManagerAccess() {
            this(Inventor.ConstructorCommand.CreateInstance, LDMManagerAccess.ctorImpl());
        }

        public SoLDMTileManager getTileManager() {
            return ObjectManager.getManagedObjectFor(SoLDMTileManager.class, LDMManagerAccess.getTileManagerImpl(this.getNativeResourceHandle()));
        }

        @Deprecated
        public boolean isTileVisitorOwnedByUser() {
            return LDMManagerAccess.isTileVisitorOwnedByUserImpl(this.getNativeResourceHandle());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }
}

