/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.nodes.SoShape;
import com.openinventor.ldm.SoLDMLargeDataManagement;
import com.openinventor.ldm.SoLDMTileID;
import com.openinventor.ldm.nodes.SoLdmShape;

public class SoLDMNodeFrontManager
extends SoLDMLargeDataManagement {
    private static native int getTileLevelImpl(long var0, long var2);

    private static native void shouldInitImpl(long var0);

    private static native long getMaxTileIDAtResolutionImpl(long var0, int var2);

    private static native void getShape2dTexTileIDImpl(long var0, long var2, long var4, long var6);

    private static native boolean registerSliceImpl(long var0, int[] var2, long var3);

    private static native void getDataTileIDImpl(long var0, long var2, long var4);

    private static native int getNextLoadedStepLevelImpl(long var0, int var2);

    private static native void reset2dTexFrontsImpl(long var0, long var2);

    private static native void setSliceMaxVisualResolutionImpl(long var0, int var2, int var3);

    private static native boolean isSliceTexFrontEmptyImpl(long var0, int var2);

    private static native int getNumFileIDsImpl(long var0);

    private static native int getFileIDImpl(long var0, long var2);

    private static native void resourceChangeNotifyImpl(long var0);

    private static native void movingChangeNotifyImpl(long var0, boolean var2);

    private static native void geomChangeNotifyImpl(long var0, boolean var2);

    private static native boolean isTextureFrontEmptyImpl(long var0);

    private static native float getWeightImpl(long var0, long var2);

    private static native void getTileIDImpl(long var0, int[] var2, int var3, long var4);

    private static native void unRegisterSliceImpl(long var0, int var2);

    private static native void getTexTileIDImpl(long var0, long var2, long var4);

    private static native void startTraversalNotifyImpl(long var0);

    private static native void getTilePosImpl(long var0, long var2, int[] var4);

    private static native void setSlicePlaneImpl(long var0, int var2, float[] var3);

    private static native int getMinResolutionImpl(long var0);

    protected SoLDMNodeFrontManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoLDMTileID getTileID(SbVec3i32 sbVec3i32) {
        return this.getTileID(sbVec3i32, 0);
    }

    public void geomChangeNotify() {
        this.geomChangeNotify(false);
    }

    public SoLDMTileID getDataTileID(SoLDMTileID soLDMTileID) {
        SoLDMTileID soLDMTileID2 = new SoLDMTileID();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.getDataTileIDImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soLDMTileID2.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return soLDMTileID2;
    }

    public void reset2dTexFronts(SoLdmShape soLdmShape) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.reset2dTexFrontsImpl(this.getNativeResourceHandle(), soLdmShape != null ? soLdmShape.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getFileID(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMNodeFrontManager.getFileIDImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbBox3i32 getTilePos(SoLDMTileID soLDMTileID) {
        SbBox3i32 sbBox3i32 = new SbBox3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.getTilePosImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, sbBox3i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbBox3i32;
    }

    public int getNumFileIDs() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMNodeFrontManager.getNumFileIDsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoLDMTileID getTexTileID(SoLDMTileID soLDMTileID) {
        SoLDMTileID soLDMTileID2 = new SoLDMTileID();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.getTexTileIDImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soLDMTileID2.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return soLDMTileID2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoLDMTileID getShape2dTexTileID(SoLdmShape soLdmShape, SoLDMTileID soLDMTileID) {
        SoLDMTileID soLDMTileID2 = new SoLDMTileID();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.getShape2dTexTileIDImpl(this.getNativeResourceHandle(), soLdmShape != null ? soLdmShape.getNativeResourceHandle() : Inventor.ZeroHandle, soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soLDMTileID2.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return soLDMTileID2;
    }

    public int getMinResolution() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMNodeFrontManager.getMinResolutionImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoLDMTileID getTileID(SbVec3i32 sbVec3i32, int n) {
        SoLDMTileID soLDMTileID = new SoLDMTileID();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.getTileIDImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, n, soLDMTileID.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return soLDMTileID;
    }

    public float getWeight(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoLDMNodeFrontManager.getWeightImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void startTraversalNotify() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.startTraversalNotifyImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxTileIDAtResolution(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoLDMNodeFrontManager.getMaxTileIDAtResolutionImpl(this.getNativeResourceHandle(), n);
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSlicePlane(int n, SbPlane sbPlane) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.setSlicePlaneImpl(this.getNativeResourceHandle(), n, sbPlane != null ? sbPlane.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void geomChangeNotify(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.geomChangeNotifyImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isTextureFrontEmpty() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLDMNodeFrontManager.isTextureFrontEmptyImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void movingChangeNotify(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.movingChangeNotifyImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSliceTexFrontEmpty(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLDMNodeFrontManager.isSliceTexFrontEmptyImpl(this.getNativeResourceHandle(), n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void resourceChangeNotify() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.resourceChangeNotifyImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setSliceMaxVisualResolution(int n, int n2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.setSliceMaxVisualResolutionImpl(this.getNativeResourceHandle(), n, n2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNextLoadedStepLevel(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoLDMNodeFrontManager.getNextLoadedStepLevelImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getTileLevel(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMNodeFrontManager.getTileLevelImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void unRegisterSlice(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.unRegisterSliceImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void shouldInit() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager.shouldInitImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerSlice(SoShape soShape) {
        int[] nArray = new int[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoLDMNodeFrontManager.registerSliceImpl(this.getNativeResourceHandle(), nArray, soShape != null ? soShape.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return nArray[0];
        }
        return 0;
    }
}

