/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.ldm.SoLDMDataAccess;
import com.openinventor.ldm.SoLDMLargeDataManagement;
import com.openinventor.ldm.SoLDMTileID;
import java.util.Collection;

public class SoLDMTileManager
extends SoLDMLargeDataManagement {
    private static native void unLockTileImpl(long var0, long var2, boolean var4);

    private static native boolean isDataInMemoryImpl(long var0, long var2);

    private static native void resourceChangeNotifyImpl(long var0);

    private static native boolean isInMemoryImpl(long var0, long var2);

    private static native void lockTileImpl(long var0, long var2);

    private static native boolean checkResidencyAndUpdateWeightImpl(long var0, long var2, float var4);

    private static native void setAllowLoadingImpl(long var0, boolean var2);

    private static native long getTileExtImpl(long var0, long var2, short var4);

    private static native void getTileDataImpl(long var0, long[] var2, int[] var3, short var4, long var5);

    private static native boolean getMinMaxImpl(long var0, long var2, double[] var4, double[] var5);

    private static native boolean requestRefetchImpl(long var0, long var2, double var4);

    private static native void releaseTileDataImpl(long var0, long var2, short var4);

    private static native long getTileImpl(long var0, long var2, short var4);

    private static native void updateRegionsImpl(long var0, Object[] var2, int var3);

    private static native void startNumDataNotifyImpl(long var0, int var2, int var3);

    private static native void unLockTilesImpl(long var0);

    private static native void initImpl(long var0, long var2);

    private static native void flushTilesOfResImpl(long var0, int var2);

    private static native int getMemoryUsedImpl(long var0);

    private static native void shouldInitImpl(long var0);

    private static native void startTransactionImpl(long var0);

    private static native void resetWeightsImpl(long var0);

    private static native void endTransactionImpl(long var0);

    private static native void lockTilesImpl(long var0);

    private static native void endNumDataNotifyImpl(long var0, boolean var2, boolean var3, boolean var4);

    private static native void prioritizeTilesImpl(long var0, long var2);

    private static native void getTileDimensionImpl(long var0, long var2, int[] var4);

    protected SoLDMTileManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void startNumDataNotify(int n) {
        this.startNumDataNotify(n, -1);
    }

    public void releaseTileData(SoLDMTileID soLDMTileID) {
        this.releaseTileData(soLDMTileID, (short)-1);
    }

    public void startNumDataNotify() {
        this.startNumDataNotify(-1, -1);
    }

    public void endNumDataNotify(boolean bl, boolean bl2) {
        this.endNumDataNotify(bl, bl2, false);
    }

    public void unLockTile(SoLDMTileID soLDMTileID) {
        this.unLockTile(soLDMTileID, false);
    }

    public boolean isDataInMemory(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLDMTileManager.isDataInMemoryImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoBufferObject getTile(SoLDMTileID soLDMTileID, short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, SoLDMTileManager.getTileImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, s));
            return soBufferObject;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isInMemory(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLDMTileManager.isInMemoryImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void resetWeights() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.resetWeightsImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoBufferObject getTileExt(SoLDMTileID soLDMTileID, short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, SoLDMTileManager.getTileExtImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, s));
            return soBufferObject;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestRefetch(SoLDMTileID soLDMTileID, double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLDMTileManager.requestRefetchImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, d);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkResidencyAndUpdateWeight(SoLDMTileID soLDMTileID, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLDMTileManager.checkResidencyAndUpdateWeightImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, f);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endNumDataNotify(boolean bl, boolean bl2, boolean bl3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.endNumDataNotifyImpl(this.getNativeResourceHandle(), bl, bl2, bl3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void startNumDataNotify(int n, int n2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.startNumDataNotifyImpl(this.getNativeResourceHandle(), n, n2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void init(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.initImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void endTransaction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.endTransactionImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void startTransaction() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.startTransactionImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3i32 getTileDimension(SoLDMTileID soLDMTileID) {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.getTileDimensionImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3i32;
    }

    public void updateRegions(SbBox3i32[] sbBox3i32Array, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.updateRegionsImpl(this.getNativeResourceHandle(), sbBox3i32Array, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void lockTiles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.lockTilesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void prioritizeTiles(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.prioritizeTilesImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void unLockTiles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.unLockTilesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void flushTilesOfRes(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.flushTilesOfResImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void shouldInit() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.shouldInitImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMemoryUsed() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMTileManager.getMemoryUsedImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void lockTile(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.lockTileImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTileData(Collection<SoLDMTileID> collection, short s, SoLDMDataAccess soLDMDataAccess) {
        if (collection == null) {
            throw new IllegalArgumentException("tileIDs cannot be null");
        }
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (SoLDMTileID soLDMTileID : collection) {
            lArray[n++] = soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle;
        }
        Object object = new int[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.getTileDataImpl(this.getNativeResourceHandle(), lArray, (int[])object, s, soLDMDataAccess != null ? soLDMDataAccess.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return (int)object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getMinMax(SoLDMTileID soLDMTileID) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoLDMTileManager.getMinMaxImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, dArray, dArray2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            double[] dArray3 = new double[]{dArray[0], dArray2[0]};
            return dArray3;
        }
        return null;
    }

    public void releaseTileData(SoLDMTileID soLDMTileID, short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.releaseTileDataImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, s);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void unLockTile(SoLDMTileID soLDMTileID, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.unLockTileImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setAllowLoading(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.setAllowLoadingImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void resourceChangeNotify() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager.resourceChangeNotifyImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static class LDMSliceAccessor
    extends Inventor {
        private static native void setLargeSliceSupportImpl(long var0, boolean var2);

        private static native long getOrthoSliceBufferImpl(long var0, long var2, int var4, int var5, long var6, boolean var8);

        private static native void releaseOrthoSliceBufferImpl(long var0, long var2);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected LDMSliceAccessor(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public SoBufferObject getOrthoSliceBuffer(SoLDMTileID soLDMTileID, int n, int n2, SoState soState) {
            return this.getOrthoSliceBuffer(soLDMTileID, n, n2, soState, false);
        }

        public SoBufferObject getOrthoSliceBuffer(SoLDMTileID soLDMTileID, int n, int n2) {
            return this.getOrthoSliceBuffer(soLDMTileID, n, n2, null, false);
        }

        public void setLargeSliceSupport(boolean bl) {
            this.acquireLock(ObjectManager.globalLock);
            try {
                LDMSliceAccessor.setLargeSliceSupportImpl(this.getNativeResourceHandle(), bl);
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }

        public void releaseOrthoSliceBuffer(SoBufferObject soBufferObject) {
            this.acquireLock(ObjectManager.globalLock);
            try {
                LDMSliceAccessor.releaseOrthoSliceBufferImpl(this.getNativeResourceHandle(), soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SoBufferObject getOrthoSliceBuffer(SoLDMTileID soLDMTileID, int n, int n2, SoState soState, boolean bl) {
            this.acquireLock(ObjectManager.globalLock);
            try {
                SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, LDMSliceAccessor.getOrthoSliceBufferImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, n, n2, soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, bl));
                return soBufferObject;
            }
            finally {
                this.releaseLock(ObjectManager.globalLock);
            }
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }
}

