/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.ldm.SoLDMLargeDataManagement;

public class SoLDMTileVisitor
extends SoLDMLargeDataManagement {
    private static native float getROIWeightImpl(long var0, int var2, float var3);

    private static native float combineParentWeightImpl(long var0, float var2, float var3);

    private static native float getSurfaceGeomWeightImpl(long var0, float var2, float var3);

    private static native float getVolumeGeomWeightImpl(long var0, float var2, float var3);

    private static native void valuationChangeNotifyImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLDMTileVisitor.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    private static native float getCullWeightImpl(long var0, float var2);

    private static native float getScreenResCullWeightImpl(long var0, float var2);

    private static native boolean isCulledImpl(long var0, float[] var2, float[] var3, int var4);

    protected SoLDMTileVisitor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public float isCulled(SbBox3f sbBox3f) {
        return this.isCulled(sbBox3f, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float isCulled(SbBox3f sbBox3f, int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoLDMTileVisitor.isCulledImpl(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null, fArray, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        return 0.0f;
    }

    public SoLDMTileVisitor() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMTileVisitor.ctorImplSync());
    }

    public void valuationChangeNotify() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileVisitor.valuationChangeNotifyImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getCullWeight(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f2 = SoLDMTileVisitor.getCullWeightImpl(this.getNativeResourceHandle(), f);
            return f2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getROIWeight(int n, float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f2 = SoLDMTileVisitor.getROIWeightImpl(this.getNativeResourceHandle(), n, f);
            return f2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float combineParentWeight(float f, float f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f3 = SoLDMTileVisitor.combineParentWeightImpl(this.getNativeResourceHandle(), f, f2);
            return f3;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getVolumeGeomWeight(float f, float f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f3 = SoLDMTileVisitor.getVolumeGeomWeightImpl(this.getNativeResourceHandle(), f, f2);
            return f3;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getScreenResCullWeight(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f2 = SoLDMTileVisitor.getScreenResCullWeightImpl(this.getNativeResourceHandle(), f);
            return f2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSurfaceGeomWeight(float f, float f2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f3 = SoLDMTileVisitor.getSurfaceGeomWeightImpl(this.getNativeResourceHandle(), f, f2);
            return f3;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static class NodeStatus
    extends Inventor {
        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native void toArrayImpl(long var0, long[] var2);

        protected NodeStatus(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public NodeStatus(NodeStatus nodeStatus) {
            this();
            this.setValue(nodeStatus);
        }

        public void setValue(NodeStatus nodeStatus) {
            NodeStatus.setValueImpl(this.getNativeResourceHandle(), nodeStatus.getNativeResourceHandle());
        }

        public static NodeStatus[] toArray(long l, long l2) {
            NodeStatus[] nodeStatusArray = new NodeStatus[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                nodeStatusArray[n] = new NodeStatus();
                lArray[n] = nodeStatusArray[n].getNativeResourceHandle();
                ++n;
            }
            NodeStatus.toArrayImpl(l, lArray);
            return nodeStatusArray;
        }

        public NodeStatus() {
            this(Inventor.ConstructorCommand.CreateInstance, NodeStatus.ctorImpl());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }
}

