/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.compressors;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SoDataCompressor
extends Inventor {
    private ByteBuffer m_src_compress;
    private ByteBuffer m_dest_uncompress;
    private static ByteBuffer m_buf_crc32;

    private static native Object getCompressedBufferImpl(long var0);

    private static native String getCompressionFormatNameImpl(long var0);

    private static native void setCompressionLevelImpl(long var0, long var2);

    private static native boolean isLosslessImpl(long var0);

    private static native long getCompressionLevelImpl(long var0);

    private static native long crc32Impl(Object var0, long var1);

    private static native Object allocateCompressedBufferImpl(long var0, long var2);

    private static native long getAppropriateCompressorImpl(String var0);

    protected SoDataCompressor(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    static native String getClassTypeId();

    public boolean isLossless() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataCompressor.isLosslessImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long crc32(ByteBuffer byteBuffer, long l) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        m_buf_crc32 = byteBuffer;
        ObjectManager.globalLock.lock();
        try {
            long l2 = SoDataCompressor.crc32Impl(byteBuffer, l);
            return l2;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void setCompressionLevel(long l) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataCompressor.setCompressionLevelImpl(this.getNativeResourceHandle(), l);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocateCompressedBuffer(long l) {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoDataCompressor.allocateCompressedBufferImpl(this.getNativeResourceHandle(), l);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public ByteBuffer getCompressedBuffer() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoDataCompressor.getCompressedBufferImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public long getCompressionLevel() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoDataCompressor.getCompressionLevelImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getCompressionFormatName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoDataCompressor.getCompressionFormatNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoDataCompressor getAppropriateCompressor(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoDataCompressor soDataCompressor = ObjectManager.getManagedObjectFor(SoDataCompressor.class, SoDataCompressor.getAppropriateCompressorImpl(string));
            return soDataCompressor;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

