/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.converters;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.ldm.SoLDMTileID;
import com.openinventor.ldm.converters.SoConverterParameters;
import com.openinventor.ldm.nodes.SoDataSet;

public class SoLDMWriter
extends Inventor {
    private static native int writeSubVolumeImpl(long var0, int[] var2, long var3, boolean var5, boolean var6);

    private static native int initializeImpl1(long var0, String var2, float[] var3, int[] var4, int var5, long var6);

    private static native int finishImpl(long var0, boolean var2);

    private static native int writeTileImpl1(long var0, long var2, long var4);

    private static native int writeTileImpl(long var0, int[] var2, long var3, int var5);

    private static native int initializeImpl3(long var0, String var2, float[] var3, int[] var4, int var5, int var6, String[] var7);

    private static native int initializeImpl(long var0, String var2, long var3, long var5);

    private static native int initializeImpl2(long var0, String var2, long var3, int var5, String[] var6);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLDMWriter.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    protected SoLDMWriter(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public int writeTile(SbVec3i32 sbVec3i32, SoBufferObject soBufferObject) {
        return this.writeTile(sbVec3i32, soBufferObject, 0);
    }

    public int finish() {
        return this.finish(true);
    }

    public int writeSubVolume(SbBox3i32 sbBox3i32, SoBufferObject soBufferObject) {
        return this.writeSubVolume(sbBox3i32, soBufferObject, true, true);
    }

    public int writeSubVolume(SbBox3i32 sbBox3i32, SoBufferObject soBufferObject, boolean bl) {
        return this.writeSubVolume(sbBox3i32, soBufferObject, bl, true);
    }

    @Deprecated
    public int initialize(String string, SoDataSet soDataSet) {
        return this.initialize(string, soDataSet, 0, (String[])null);
    }

    @Deprecated
    public int initialize(String string, SbBox3f sbBox3f, SbVec3i32 sbVec3i32, SoDataSet.DataTypes dataTypes) {
        return this.initialize(string, sbBox3f, sbVec3i32, dataTypes, 0, null);
    }

    @Deprecated
    public int initialize(String string, SbBox3f sbBox3f, SbVec3i32 sbVec3i32, SoDataSet.DataTypes dataTypes, int n) {
        return this.initialize(string, sbBox3f, sbVec3i32, dataTypes, n, null);
    }

    @Deprecated
    public int initialize(String string, SoDataSet soDataSet, int n) {
        return this.initialize(string, soDataSet, n, (String[])null);
    }

    public SoLDMWriter() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMWriter.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int initialize(String string, SbBox3f sbBox3f, SbVec3i32 sbVec3i32, SoDataSet.DataTypes dataTypes, int n, String[] stringArray) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoLDMWriter.initializeImpl3(this.getNativeResourceHandle(), string, sbBox3f != null ? sbBox3f.array : null, sbVec3i32 != null ? sbVec3i32.array : null, dataTypes.getValue(), n, stringArray);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeTile(SbVec3i32 sbVec3i32, SoBufferObject soBufferObject, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoLDMWriter.writeTileImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int initialize(String string, SoDataSet soDataSet, int n, String[] stringArray) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoLDMWriter.initializeImpl2(this.getNativeResourceHandle(), string, soDataSet != null ? soDataSet.getNativeResourceHandle() : Inventor.ZeroHandle, n, stringArray);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeTile(SoLDMTileID soLDMTileID, SoBufferObject soBufferObject) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMWriter.writeTileImpl1(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initialize(String string, SoDataSet soDataSet, SoConverterParameters soConverterParameters) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMWriter.initializeImpl(this.getNativeResourceHandle(), string, soDataSet != null ? soDataSet.getNativeResourceHandle() : Inventor.ZeroHandle, soConverterParameters != null ? soConverterParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int finish(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMWriter.finishImpl(this.getNativeResourceHandle(), bl);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeSubVolume(SbBox3i32 sbBox3i32, SoBufferObject soBufferObject, boolean bl, boolean bl2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMWriter.writeSubVolumeImpl(this.getNativeResourceHandle(), sbBox3i32 != null ? sbBox3i32.array : null, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, bl, bl2);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initialize(String string, SbBox3f sbBox3f, SbVec3i32 sbVec3i32, SoDataSet.DataTypes dataTypes, SoConverterParameters soConverterParameters) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMWriter.initializeImpl1(this.getNativeResourceHandle(), string, sbBox3f != null ? sbBox3f.array : null, sbVec3i32 != null ? sbVec3i32.array : null, dataTypes.getValue(), soConverterParameters != null ? soConverterParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

