/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.elements.SoReplacedElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.ldm.SoLDMTileManager;
import com.openinventor.ldm.nodes.SoDataSet;

public class SoDataSetElement
extends SoReplacedElement {
    private SoState m_state_setElt;

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoDataSetElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native boolean matchesImpl(long var0, long var2);

    private static native long copyMatchInfoImpl(long var0);

    private static native long ctorImpl();

    private static native void getDataSetImpl(long var0, long[] var2);

    private static native void pushImpl(long var0, long var2);

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native void nativeDerivedClassInit();

    private static native void setEltImpl(long var0, long var2, long var4);

    private static native void setEltImpl1(long var0, long var2, long var4, float[] var6);

    private static native void setImpl(long var0, long var2, long var4);

    private static native void setImpl1(long var0, long var2, long var4, float[] var6);

    private static native void initImpl(long var0, long var2);

    private static native int getClassStackIndexImpl();

    private static native void getTileManagerImpl(long var0, long[] var2);

    protected SoDataSetElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoDataSetElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    @Override
    protected SoElement copyMatchInfo() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoElement soElement = ObjectManager.getManagedObjectFor(SoElement.class, SoDataSetElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
            return soElement;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected void setElt(SoState soState, SoDataSet soDataSet) {
        this.m_state_setElt = soState;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSetElement.setEltImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soDataSet != null ? soDataSet.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Override
    protected void init(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSetElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    protected SoDataSetElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoDataSetElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = SoDataSetElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    @Override
    protected boolean matches(SoElement soElement) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSetElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setElt(SoState soState, SoDataSet soDataSet, SbMatrix sbMatrix) {
        this.m_state_setElt = soState;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSetElement.setEltImpl1(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soDataSet != null ? soDataSet.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoDataSet getDataSet(SoState soState) {
        long[] lArray = new long[1];
        ObjectManager.globalLock.lock();
        try {
            SoDataSetElement.getDataSetImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, lArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return ObjectManager.getManagedObjectFor(SoDataSet.class, lArray[0]);
    }

    public static SoLDMTileManager getTileManager(SoState soState) {
        long[] lArray = new long[1];
        ObjectManager.globalLock.lock();
        try {
            SoDataSetElement.getTileManagerImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, lArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return ObjectManager.getManagedObjectFor(SoLDMTileManager.class, lArray[0]);
    }

    public static void set(SoState soState, SoNode soNode, SoDataSet soDataSet) {
        ObjectManager.globalLock.lock();
        try {
            SoDataSetElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soDataSet != null ? soDataSet.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Override
    public void push(SoState soState) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSetElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(SoState soState, SoNode soNode, SoDataSet soDataSet, SbMatrix sbMatrix) {
        ObjectManager.globalLock.lock();
        try {
            SoDataSetElement.setImpl1(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soDataSet != null ? soDataSet.getNativeResourceHandle() : Inventor.ZeroHandle, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoDataSetElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        SoDataSetElement.nativeDerivedClassInit();
    }
}

