/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFBox3f;
import com.openinventor.inventor.fields.SoSFFilePathString;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFUShort;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.ldm.SoLDMDataAccess;
import com.openinventor.ldm.SoLDMGeometry;
import com.openinventor.ldm.SoLDMMediator;
import com.openinventor.ldm.SoLDMNodeFrontManager;
import com.openinventor.ldm.SoLDMTileID;
import com.openinventor.ldm.SoLDMTileManager;
import com.openinventor.ldm.SoLDMTileVisitor;
import com.openinventor.ldm.fields.SoSFLDMDataTransform;
import com.openinventor.ldm.fields.SoSFLDMResourceParameters;
import com.openinventor.ldm.readers.SoLDMReader;
import com.openinventor.ldm.readers.SoVolumeReader;
import com.openinventor.ldm.writers.SoVolumeWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Hashtable;

public abstract class SoDataSet
extends SoNode {
    private static Hashtable<Long, LDMDataModifier> s_dataModifiers = new Hashtable();
    private SoVolumeReader m_customReader;
    @Deprecated
    public static final int UNSIGNED_BYTE = DataTypes.access$000();
    @Deprecated
    public static final int UNSIGNED_SHORT = DataTypes.access$100();
    @Deprecated
    public static final int UNSIGNED_INT32 = DataTypes.access$200();
    @Deprecated
    public static final int SIGNED_BYTE = DataTypes.access$300();
    @Deprecated
    public static final int SIGNED_SHORT = DataTypes.access$400();
    @Deprecated
    public static final int SIGNED_INT32 = DataTypes.access$500();
    @Deprecated
    public static final int FLOAT = DataTypes.access$600();
    public final SoSFInt32 dataSetId;
    public final SoSFFilePathString fileName;
    public final SoSFBool useCompressedTexture;
    public final SoSFUShort texturePrecision;
    public final SoSFBox3f extent;
    public final SoSFLDMDataTransform dataTransform;
    public final SoSFBool allocateResourceOnRender;
    public final SoSFLDMResourceParameters ldmResourceParameters;
    private SoLDMTileVisitor m_tileVisitor_setTileVisitor;

    @Deprecated
    public void setLDMDataModifier(LDMDataModifier lDMDataModifier) {
        s_dataModifiers.remove(this.getNativeResourceHandle());
        if (lDMDataModifier != null) {
            s_dataModifiers.put(this.getNativeResourceHandle(), lDMDataModifier);
            SoDataSet.setLDMDataModifierNativ(this.getNativeResourceHandle());
        }
    }

    private static native void setLDMDataModifierNativ(long var0);

    private static void notifyModifier(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.nativeOrder());
        LDMDataModifier lDMDataModifier = s_dataModifiers.get(l);
        try {
            lDMDataModifier.modifyData(new SbBox3i32(n, n2, n3, n4, n5, n6), n7, byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onSetReader(SoVolumeReader soVolumeReader) {
        this.m_customReader = soVolumeReader;
    }

    private void onResetReader() {
        this.m_customReader = null;
    }

    private static native int getDataTypeImpl(long var0);

    private static native int editSubVolumeImpl1(long var0, int[] var2, double var3);

    private static native int editTileImpl1(long var0, long var2, double var4);

    private static native boolean getDoubleMinMaxImpl(long var0, double[] var2, double[] var3);

    private static native int editSolidShapeImpl(long var0, long var2, double var4);

    private static native int editSurfaceShapeImpl(long var0, long var2, float var4, double var5);

    private static native int getDataSizeImpl(long var0);

    private static native boolean isTimeDependentImpl(long var0);

    private static native boolean finishEditingImpl(long var0, int var2);

    private static native int getNumTimeStepsImpl(long var0);

    private static native int editSubVolumeImpl(long var0, int[] var2, long var3);

    private static native void setReaderImpl(long var0, long var2, boolean var4);

    private static native int editTileImpl(long var0, long var2, long var4);

    private static native void setTileVisitorImpl(long var0, long var2);

    private static native long getReaderImpl(long var0);

    private static native long getTileVisitorImpl(long var0);

    private static native long getNodeFrontManagerImpl(long var0);

    private static native void setLDMReaderImpl(long var0, long var2);

    private static native long getVVizGeometryImpl(long var0);

    private static native long getTileManagerImpl(long var0);

    private static native boolean getMinMaxImpl(long var0, long[] var2, long[] var3);

    private static native boolean undoEditingImpl(long var0, int var2);

    private static native int editBoxesImpl(long var0, Object[] var2, int var3, double var4);

    private static native int numSigBitsImpl(long var0);

    private static native boolean hasEditedTileImpl(long var0);

    private static native boolean redoEditingImpl(long var0, int var2);

    private static native void getTileDimensionImpl(long var0, int[] var2);

    private static native void getDimensionImpl(long var0, int[] var2);

    private static native int getMaxNumDataSetsImpl();

    private static native int dataSizeImpl(int var0);

    private static native boolean isDataSignedImpl(int var0);

    private static native boolean isDataFloatImpl(int var0);

    private static native void setLDMImpl(long var0, boolean var2);

    private static native void writeTileImpl(long var0, long var2, long var4, long var6);

    private static native void readTileImpl(long var0, long var2, long var4, boolean var6);

    private static native boolean startEditingImpl(long var0, int[] var2);

    private static native int getOverlappingImpl(long var0);

    private static native long getLdmDataAccessImpl(long var0);

    private static native int getDatumSizeImpl(long var0);

    private static native void resetReaderImpl(long var0);

    private static native void getLdmManagerAccessImpl(long var0, long var2);

    private static native long getLDMReaderImpl(long var0);

    protected SoDataSet(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.dataSetId = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "dataSetId"));
        this.fileName = ObjectManager.getManagedObjectFor(SoSFFilePathString.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "fileName"));
        this.useCompressedTexture = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "useCompressedTexture"));
        this.texturePrecision = ObjectManager.getManagedObjectFor(SoSFUShort.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "texturePrecision"));
        this.extent = ObjectManager.getManagedObjectFor(SoSFBox3f.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "extent"));
        this.dataTransform = ObjectManager.getManagedObjectFor(SoSFLDMDataTransform.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "dataTransform"));
        this.allocateResourceOnRender = ObjectManager.getManagedObjectFor(SoSFBool.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "allocateResourceOnRender"));
        this.ldmResourceParameters = ObjectManager.getManagedObjectFor(SoSFLDMResourceParameters.class, SoDataSet.getFieldHandle(this.getNativeResourceHandle(), "ldmResourceParameters"));
    }

    static native String getClassTypeId();

    public void setReader(SoVolumeReader soVolumeReader) {
        this.setReader(soVolumeReader, false);
    }

    public int startEditing() {
        int[] nArray = new int[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoDataSet.startEditingImpl(this.getNativeResourceHandle(), nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return nArray[0];
        }
        return 0;
    }

    public SoLDMDataAccess getLdmDataAccess() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMDataAccess soLDMDataAccess = ObjectManager.getManagedObjectFor(SoLDMDataAccess.class, SoDataSet.getLdmDataAccessImpl(this.getNativeResourceHandle()));
            return soLDMDataAccess;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTile(SoLDMTileID soLDMTileID, SoBufferObject soBufferObject, boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.readTileImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTile(SoLDMTileID soLDMTileID, SoBufferObject soBufferObject, SoVolumeWriter soVolumeWriter) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.writeTileImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, soVolumeWriter != null ? soVolumeWriter.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean finishEditing(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSet.finishEditingImpl(this.getNativeResourceHandle(), n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editSubVolume(SbBox3i32 sbBox3i32, double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.editSubVolumeImpl1(this.getNativeResourceHandle(), sbBox3i32 != null ? sbBox3i32.array : null, d);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editSurfaceShape(SoNode soNode, float f, double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.editSurfaceShapeImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, f, d);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editTile(SoLDMTileID soLDMTileID, double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.editTileImpl1(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, d);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editTile(SoLDMTileID soLDMTileID, SoBufferObject soBufferObject) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.editTileImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editSubVolume(SbBox3i32 sbBox3i32, SoBufferObject soBufferObject) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.editSubVolumeImpl(this.getNativeResourceHandle(), sbBox3i32 != null ? sbBox3i32.array : null, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public void setLDM(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.setLDMImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static boolean isDataSigned(DataTypes dataTypes) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDataSet.isDataSignedImpl(dataTypes.getValue());
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean isDataFloat(DataTypes dataTypes) {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = SoDataSet.isDataFloatImpl(dataTypes.getValue());
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static int dataSize(DataTypes dataTypes) {
        ObjectManager.globalLock.lock();
        try {
            int n = SoDataSet.dataSizeImpl(dataTypes.getValue());
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public int getNumTimeSteps() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.getNumTimeStepsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void resetReader() {
        this.onResetReader();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.resetReaderImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3i32 getTileDimension() {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.getTileDimensionImpl(this.getNativeResourceHandle(), sbVec3i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3i32;
    }

    public int getDatumSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.getDatumSizeImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3i32 getDimension() {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.getDimensionImpl(this.getNativeResourceHandle(), sbVec3i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3i32;
    }

    public static int getMaxNumDataSets() {
        ObjectManager.globalLock.lock();
        try {
            int n = SoDataSet.getMaxNumDataSetsImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public SoLDMMediator.LDMManagerAccess getLdmManagerAccess() {
        SoLDMMediator.LDMManagerAccess lDMManagerAccess = new SoLDMMediator.LDMManagerAccess();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.getLdmManagerAccessImpl(this.getNativeResourceHandle(), lDMManagerAccess.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return lDMManagerAccess;
    }

    public int numSigBits() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.numSigBitsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getMinMax() {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoDataSet.getMinMaxImpl(this.getNativeResourceHandle(), lArray, lArray2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            long[] lArray3 = new long[]{lArray[0], lArray2[0]};
            return lArray3;
        }
        return null;
    }

    public SoVolumeReader getReader() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, SoDataSet.getReaderImpl(this.getNativeResourceHandle()));
            return soVolumeReader;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoLDMReader getLDMReader() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMReader soLDMReader = ObjectManager.getManagedObjectFor(SoLDMReader.class, SoDataSet.getLDMReaderImpl(this.getNativeResourceHandle()));
            return soLDMReader;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setLDMReader(SoLDMReader soLDMReader) {
        this.onSetReader(soLDMReader);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.setLDMReaderImpl(this.getNativeResourceHandle(), soLDMReader != null ? soLDMReader.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setReader(SoVolumeReader soVolumeReader, boolean bl) {
        this.onSetReader(soVolumeReader);
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.setReaderImpl(this.getNativeResourceHandle(), soVolumeReader != null ? soVolumeReader.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public boolean isTimeDependent() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSet.isTimeDependentImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getDataSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.getDataSizeImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getDoubleMinMax() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoDataSet.getDoubleMinMaxImpl(this.getNativeResourceHandle(), dArray, dArray2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            double[] dArray3 = new double[]{dArray[0], dArray2[0]};
            return dArray3;
        }
        return null;
    }

    public DataTypes getDataType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            DataTypes dataTypes = IntegerValuedEnumHelper.fromIntValue(DataTypes.class, SoDataSet.getDataTypeImpl(this.getNativeResourceHandle()));
            return dataTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoLDMNodeFrontManager getNodeFrontManager() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMNodeFrontManager soLDMNodeFrontManager = ObjectManager.getManagedObjectFor(SoLDMNodeFrontManager.class, SoDataSet.getNodeFrontManagerImpl(this.getNativeResourceHandle()));
            return soLDMNodeFrontManager;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean redoEditing(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSet.redoEditingImpl(this.getNativeResourceHandle(), n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean hasEditedTile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSet.hasEditedTileImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean undoEditing(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoDataSet.undoEditingImpl(this.getNativeResourceHandle(), n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editSolidShape(SoNode soNode, double d) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.editSolidShapeImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, d);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int editBoxes(Collection<SbVec3i32> collection, int n, double d) {
        if (collection == null) {
            throw new IllegalArgumentException("boxCenters cannot be null");
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoDataSet.editBoxesImpl(this.getNativeResourceHandle(), collection.toArray(), n, d);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public void setTileVisitor(SoLDMTileVisitor soLDMTileVisitor) {
        this.m_tileVisitor_setTileVisitor = soLDMTileVisitor;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoDataSet.setTileVisitorImpl(this.getNativeResourceHandle(), soLDMTileVisitor != null ? soLDMTileVisitor.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public SoLDMGeometry getVVizGeometry() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMGeometry soLDMGeometry = ObjectManager.getManagedObjectFor(SoLDMGeometry.class, SoDataSet.getVVizGeometryImpl(this.getNativeResourceHandle()));
            return soLDMGeometry;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public SoLDMTileVisitor getTileVisitor() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileVisitor soLDMTileVisitor = ObjectManager.getManagedObjectFor(SoLDMTileVisitor.class, SoDataSet.getTileVisitorImpl(this.getNativeResourceHandle()));
            return soLDMTileVisitor;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoLDMTileManager getTileManager() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMTileManager soLDMTileManager = ObjectManager.getManagedObjectFor(SoLDMTileManager.class, SoDataSet.getTileManagerImpl(this.getNativeResourceHandle()));
            return soLDMTileManager;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public int getOverlapping() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoDataSet.getOverlappingImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum DataTypes implements IntegerValuedEnum
    {
        UNSIGNED_BYTE(DataTypes.getUNSIGNEDBYTE()),
        UNSIGNED_SHORT(DataTypes.getUNSIGNEDSHORT()),
        UNSIGNED_INT32(DataTypes.getUNSIGNEDINT32()),
        SIGNED_BYTE(DataTypes.getSIGNEDBYTE()),
        SIGNED_SHORT(DataTypes.getSIGNEDSHORT()),
        SIGNED_INT32(DataTypes.getSIGNEDINT32()),
        FLOAT(DataTypes.getFLOAT());

        private int value;

        private static native int getSIGNEDINT32();

        private static native int getSIGNEDSHORT();

        private DataTypes(int n2) {
            this.value = n2;
        }

        private static native int getFLOAT();

        private static native int getUNSIGNEDSHORT();

        private static native int getUNSIGNEDBYTE();

        private static native int getSIGNEDBYTE();

        private static native int getUNSIGNEDINT32();

        @Deprecated
        public static DataTypes fromValue(int n) {
            return DataTypes.valueOf(n);
        }

        public static DataTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DataTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return DataTypes.getUNSIGNEDBYTE();
        }

        static /* synthetic */ int access$100() {
            return DataTypes.getUNSIGNEDSHORT();
        }

        static /* synthetic */ int access$200() {
            return DataTypes.getUNSIGNEDINT32();
        }

        static /* synthetic */ int access$300() {
            return DataTypes.getSIGNEDBYTE();
        }

        static /* synthetic */ int access$400() {
            return DataTypes.getSIGNEDSHORT();
        }

        static /* synthetic */ int access$500() {
            return DataTypes.getSIGNEDINT32();
        }

        static /* synthetic */ int access$600() {
            return DataTypes.getFLOAT();
        }
    }

    @Deprecated
    public abstract class LDMDataModifier {
        public void modifyData(SbBox3i32 sbBox3i32, int n, ByteBuffer byteBuffer) {
            this.modifyData(sbBox3i32, n, (Buffer)byteBuffer);
        }

        public void modifyData(SbBox3i32 sbBox3i32, int n, Buffer buffer) {
        }
    }
}

