/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.nodes;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFVec3i32;

public class SoLDMResourceParameters
extends SoFieldContainer {
    @Deprecated
    public static final int NO_USER_INTERACTION = LoadPolicies.access$200();
    @Deprecated
    public static final int ALWAYS = LoadPolicies.access$300();
    @Deprecated
    public static final int NEVER = LoadPolicies.access$400();
    public final SoSFInt32 maxMainMemory;
    public final SoSFInt32 maxTexMemory;
    public final SoSFEnum<LoadPolicies> loadPolicy;
    public final SoSFInt32 tex3LoadRate;
    public final SoSFInt32 max2DTexMemory;
    @Deprecated
    public final SoSFInt32 max2DTextures;
    public final SoSFInt32 tex2LoadRate;
    public final SoSFInt32 minResolutionThreshold;
    public final SoSFInt32 maxResolutionThreshold;
    public final SoSFVec3i32 tileDimension;
    public final SoSFVec3i32 subTileDimension;
    public final SoSFInt32 loadNotificationRate;
    public final SoSFFloat tileHalfLife;
    public final SoSFBool fixedResolution;
    public final SoSFInt32 resolution;
    public final SoSFInt32 numPrefetchThread;
    @Deprecated
    public final SoSFInt32 maxNumTriangles;
    @Deprecated
    public final SoSFInt32 overlapping;
    @Deprecated
    public final SoSFInt32 maxTilesInMainMem;
    @Deprecated
    public final SoSFInt32 maxTilesInTexMem;
    @Deprecated
    public final SoSFBool fixedParams;

    private static native float getMovingTimeOutImpl(long var0);

    private static native int getDataSizeImpl(long var0);

    private static native boolean getGeometryPriorityImpl(long var0, String var2, float[] var3);

    private static native void setGeometryPriorityImpl(long var0, String var2, float var3);

    private static native void setMovingTimeOutImpl(long var0, float var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLDMResourceParameters.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    protected SoLDMResourceParameters(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.maxMainMemory = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "maxMainMemory"));
        this.maxTexMemory = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "maxTexMemory"));
        this.loadPolicy = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "loadPolicy"), LoadPolicies.class);
        this.tex3LoadRate = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "tex3LoadRate"));
        this.max2DTexMemory = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "max2DTexMemory"));
        this.max2DTextures = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "max2DTextures"));
        this.tex2LoadRate = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "tex2LoadRate"));
        this.minResolutionThreshold = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "minResolutionThreshold"));
        this.maxResolutionThreshold = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "maxResolutionThreshold"));
        this.tileDimension = ObjectManager.getManagedObjectFor(SoSFVec3i32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "tileDimension"));
        this.subTileDimension = ObjectManager.getManagedObjectFor(SoSFVec3i32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "subTileDimension"));
        this.loadNotificationRate = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "loadNotificationRate"));
        this.tileHalfLife = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "tileHalfLife"));
        this.fixedResolution = ObjectManager.getManagedObjectFor(SoSFBool.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "fixedResolution"));
        this.resolution = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "resolution"));
        this.numPrefetchThread = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "numPrefetchThread"));
        this.maxNumTriangles = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "maxNumTriangles"));
        this.overlapping = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "overlapping"));
        this.maxTilesInMainMem = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "maxTilesInMainMem"));
        this.maxTilesInTexMem = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "maxTilesInTexMem"));
        this.fixedParams = ObjectManager.getManagedObjectFor(SoSFBool.class, SoLDMResourceParameters.getFieldHandle(this.getNativeResourceHandle(), "fixedParams"));
    }

    static native String getClassTypeId();

    public int getDataSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoLDMResourceParameters.getDataSizeImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoLDMResourceParameters() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMResourceParameters.ctorImplSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeometryPriority(Class<? extends Inventor> clazz, float f) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMResourceParameters.setGeometryPriorityImpl(this.getNativeResourceHandle(), string, f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getGeometryPriority(Class<? extends Inventor> clazz) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoLDMResourceParameters.getGeometryPriorityImpl(this.getNativeResourceHandle(), string, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        return 0.0f;
    }

    public void setMovingTimeOut(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMResourceParameters.setMovingTimeOutImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getMovingTimeOut() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoLDMResourceParameters.getMovingTimeOutImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static class FixedResolutionReport
    extends Inventor {
        @Deprecated
        public static final int PROGRESS = ReportCodes.access$000();
        @Deprecated
        public static final int ABORT = ReportCodes.access$100();

        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native void toArrayImpl(long var0, long[] var2);

        protected FixedResolutionReport(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public FixedResolutionReport(FixedResolutionReport fixedResolutionReport) {
            this();
            this.setValue(fixedResolutionReport);
        }

        public void setValue(FixedResolutionReport fixedResolutionReport) {
            FixedResolutionReport.setValueImpl(this.getNativeResourceHandle(), fixedResolutionReport.getNativeResourceHandle());
        }

        public static FixedResolutionReport[] toArray(long l, long l2) {
            FixedResolutionReport[] fixedResolutionReportArray = new FixedResolutionReport[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                fixedResolutionReportArray[n] = new FixedResolutionReport();
                lArray[n] = fixedResolutionReportArray[n].getNativeResourceHandle();
                ++n;
            }
            FixedResolutionReport.toArrayImpl(l, lArray);
            return fixedResolutionReportArray;
        }

        public FixedResolutionReport() {
            this(Inventor.ConstructorCommand.CreateInstance, FixedResolutionReport.ctorImpl());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }

        public static enum ReportCodes implements IntegerValuedEnum
        {
            PROGRESS(ReportCodes.getPROGRESS()),
            ABORT(ReportCodes.getABORT());

            private int value;

            private ReportCodes(int n2) {
                this.value = n2;
            }

            private static native int getABORT();

            private static native int getPROGRESS();

            @Deprecated
            public static ReportCodes fromValue(int n) {
                return ReportCodes.valueOf(n);
            }

            public static ReportCodes valueOf(int n) {
                return IntegerValuedEnumHelper.fromIntValue(ReportCodes.class, n);
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static /* synthetic */ int access$000() {
                return ReportCodes.getPROGRESS();
            }

            static /* synthetic */ int access$100() {
                return ReportCodes.getABORT();
            }
        }
    }

    public static enum LoadPolicies implements IntegerValuedEnum
    {
        NO_USER_INTERACTION(LoadPolicies.getNOUSERINTERACTION()),
        ALWAYS(LoadPolicies.getALWAYS()),
        NEVER(LoadPolicies.getNEVER());

        private int value;

        private static native int getNEVER();

        private LoadPolicies(int n2) {
            this.value = n2;
        }

        private static native int getNOUSERINTERACTION();

        private static native int getALWAYS();

        @Deprecated
        public static LoadPolicies fromValue(int n) {
            return LoadPolicies.valueOf(n);
        }

        public static LoadPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LoadPolicies.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$200() {
            return LoadPolicies.getNOUSERINTERACTION();
        }

        static /* synthetic */ int access$300() {
            return LoadPolicies.getALWAYS();
        }

        static /* synthetic */ int access$400() {
            return LoadPolicies.getNEVER();
        }
    }
}

