/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.readers;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.ldm.readers.SoVolumeReader;
import com.openinventor.ldm.xml.SbXmlTag;

public class SoLDMReader
extends SoVolumeReader {
    private static boolean s_checklic = true;
    @Deprecated
    public static final int LDM_NO_ERROR = SoLDMErrors.access$000();
    @Deprecated
    public static final int LDM_FILE_NOT_FOUND = SoLDMErrors.access$100();
    @Deprecated
    public static final int LDM_XML_ROOT_START_TAG_NOT_FOUND = SoLDMErrors.access$200();
    @Deprecated
    public static final int LDM_XML_ROOT_END_TAG_NOT_FOUND = SoLDMErrors.access$300();
    @Deprecated
    public static final int LDM_ALTERNATE_FILE_NOT_FOUND = SoLDMErrors.access$400();
    @Deprecated
    public static final int LDM_XML_PARSING_ERROR = SoLDMErrors.access$500();
    @Deprecated
    public static final int LDM_SIZE_TAG_MISSING = SoLDMErrors.access$600();
    @Deprecated
    public static final int LDM_COMPLETION_FILE_NOT_FOUND = SoLDMErrors.access$700();
    @Deprecated
    public static final int LDM_RD_NO_ERROR = SoLDMErrors.access$800();
    @Deprecated
    public static final int LDM_RD_FILE_NOT_FOUND_ERROR = SoLDMErrors.access$900();
    @Deprecated
    public static final int LDM_RD_UNSUPPORTED_DATA_TYPE_ERROR = SoLDMErrors.access$1000();
    @Deprecated
    public static final int LDM_RD_UNKNOWN_ERROR = SoLDMErrors.access$1100();

    private static native void getDimensionImpl(long var0, int[] var2);

    private static native boolean getBboxImpl(long var0, int var2, float[] var3);

    private static native boolean isLittleEndianImpl(long var0);

    private static native long getXmlTagImpl(long var0, String var2);

    private static native boolean getCenterImpl(long var0, int var2, float[] var3);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoLDMReader.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void getSizeImpl(long var0, float[] var2);

    private static native long ctorImpl();

    protected SoLDMReader(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        if (s_checklic) {
            Inventor.checkVldmLP();
            s_checklic = false;
        }
        this.initializeFields();
    }

    static native String getClassTypeId();

    public SoLDMReader() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLDMReader.ctorImplSync());
    }

    public SbXmlTag getXmlTag(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SbXmlTag sbXmlTag = ObjectManager.createManagedObject(SbXmlTag.class, (Long)SoLDMReader.getXmlTagImpl(this.getNativeResourceHandle(), string), Inventor.ConstructorCommand.CreateInstance);
            return sbXmlTag;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3f getCenter(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoLDMReader.getCenterImpl(this.getNativeResourceHandle(), n, sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbVec3f;
        }
        return null;
    }

    public boolean isLittleEndian() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoLDMReader.isLittleEndianImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbBox3f getBbox(int n) {
        SbBox3f sbBox3f = new SbBox3f();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoLDMReader.getBboxImpl(this.getNativeResourceHandle(), n, sbBox3f != null ? sbBox3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbBox3f;
        }
        return null;
    }

    public SbBox3f getSize() {
        SbBox3f sbBox3f = new SbBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMReader.getSizeImpl(this.getNativeResourceHandle(), sbBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbBox3f;
    }

    public SbVec3i32 getDimension() {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoLDMReader.getDimensionImpl(this.getNativeResourceHandle(), sbVec3i32.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3i32;
    }

    public static enum SoLDMErrors implements IntegerValuedEnum
    {
        LDM_NO_ERROR(SoLDMErrors.getLDMNOERROR()),
        LDM_FILE_NOT_FOUND(SoLDMErrors.getLDMFILENOTFOUND()),
        LDM_XML_ROOT_START_TAG_NOT_FOUND(SoLDMErrors.getLDMXMLROOTSTARTTAGNOTFOUND()),
        LDM_XML_ROOT_END_TAG_NOT_FOUND(SoLDMErrors.getLDMXMLROOTENDTAGNOTFOUND()),
        LDM_ALTERNATE_FILE_NOT_FOUND(SoLDMErrors.getLDMALTERNATEFILENOTFOUND()),
        LDM_XML_PARSING_ERROR(SoLDMErrors.getLDMXMLPARSINGERROR()),
        LDM_SIZE_TAG_MISSING(SoLDMErrors.getLDMSIZETAGMISSING()),
        LDM_COMPLETION_FILE_NOT_FOUND(SoLDMErrors.getLDMCOMPLETIONFILENOTFOUND()),
        LDM_RD_NO_ERROR(SoLDMErrors.getLDMRDNOERROR()),
        LDM_RD_FILE_NOT_FOUND_ERROR(SoLDMErrors.getLDMRDFILENOTFOUNDERROR()),
        LDM_RD_UNSUPPORTED_DATA_TYPE_ERROR(SoLDMErrors.getLDMRDUNSUPPORTEDDATATYPEERROR()),
        LDM_RD_UNKNOWN_ERROR(SoLDMErrors.getLDMRDUNKNOWNERROR());

        private int value;

        private static native int getLDMRDFILENOTFOUNDERROR();

        private static native int getLDMRDNOERROR();

        private static native int getLDMCOMPLETIONFILENOTFOUND();

        private SoLDMErrors(int n2) {
            this.value = n2;
        }

        private static native int getLDMRDUNKNOWNERROR();

        private static native int getLDMRDUNSUPPORTEDDATATYPEERROR();

        private static native int getLDMSIZETAGMISSING();

        private static native int getLDMXMLROOTSTARTTAGNOTFOUND();

        private static native int getLDMFILENOTFOUND();

        private static native int getLDMNOERROR();

        private static native int getLDMXMLPARSINGERROR();

        private static native int getLDMALTERNATEFILENOTFOUND();

        private static native int getLDMXMLROOTENDTAGNOTFOUND();

        @Deprecated
        public static SoLDMErrors fromValue(int n) {
            return SoLDMErrors.valueOf(n);
        }

        public static SoLDMErrors valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SoLDMErrors.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return SoLDMErrors.getLDMNOERROR();
        }

        static /* synthetic */ int access$100() {
            return SoLDMErrors.getLDMFILENOTFOUND();
        }

        static /* synthetic */ int access$200() {
            return SoLDMErrors.getLDMXMLROOTSTARTTAGNOTFOUND();
        }

        static /* synthetic */ int access$300() {
            return SoLDMErrors.getLDMXMLROOTENDTAGNOTFOUND();
        }

        static /* synthetic */ int access$400() {
            return SoLDMErrors.getLDMALTERNATEFILENOTFOUND();
        }

        static /* synthetic */ int access$500() {
            return SoLDMErrors.getLDMXMLPARSINGERROR();
        }

        static /* synthetic */ int access$600() {
            return SoLDMErrors.getLDMSIZETAGMISSING();
        }

        static /* synthetic */ int access$700() {
            return SoLDMErrors.getLDMCOMPLETIONFILENOTFOUND();
        }

        static /* synthetic */ int access$800() {
            return SoLDMErrors.getLDMRDNOERROR();
        }

        static /* synthetic */ int access$900() {
            return SoLDMErrors.getLDMRDFILENOTFOUNDERROR();
        }

        static /* synthetic */ int access$1000() {
            return SoLDMErrors.getLDMRDUNSUPPORTEDDATATYPEERROR();
        }

        static /* synthetic */ int access$1100() {
            return SoLDMErrors.getLDMRDUNKNOWNERROR();
        }
    }
}

