/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.readers;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox2i32;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbVec2d;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.SbVec3s;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.ldm.nodes.SoDataSet;
import com.openinventor.ldm.writers.SoVolumeWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SoVolumeReader
extends SoFieldContainer {
    private boolean customVolumeReader = false;
    @Deprecated
    public static final int RD_NO_ERROR = ReadErrors.access$000();
    @Deprecated
    public static final int RD_FILE_NOT_FOUND_ERROR = ReadErrors.access$100();
    @Deprecated
    public static final int RD_INVALID_DATA_ERROR = ReadErrors.access$200();
    @Deprecated
    public static final int RD_UNSUPPORTED_DATA_TYPE_ERROR = ReadErrors.access$300();
    @Deprecated
    public static final int RD_FILE_FORMAT_NOT_VALID_ERROR = ReadErrors.access$400();
    @Deprecated
    public static final int RD_UNKNOWN_ERROR = ReadErrors.access$500();
    @Deprecated
    public static final int X = Axis.access$600();
    @Deprecated
    public static final int Y = Axis.access$700();
    @Deprecated
    public static final int Z = Axis.access$800();
    @Deprecated
    public static final int COPY = CopyPolicies.access$900();
    @Deprecated
    public static final int NO_COPY = CopyPolicies.access$1000();
    @Deprecated
    public static final int NO_READER = ReaderTypes.access$1100();
    @Deprecated
    public static final int AM = ReaderTypes.access$1200();
    @Deprecated
    public static final int AVS = ReaderTypes.access$1300();
    @Deprecated
    public static final int DICOM = ReaderTypes.access$1400();
    @Deprecated
    public static final int GENERIC = ReaderTypes.access$1500();
    @Deprecated
    public static final int LDM = ReaderTypes.access$1600();
    @Deprecated
    public static final int MEMORY = ReaderTypes.access$1700();
    @Deprecated
    public static final int RASTERSTACK = ReaderTypes.access$1800();
    @Deprecated
    public static final int SEGY = ReaderTypes.access$1900();
    @Deprecated
    public static final int VOL = ReaderTypes.access$2000();
    @Deprecated
    public static final int VOX = ReaderTypes.access$2100();
    @Deprecated
    public static final int TIFF = ReaderTypes.access$2200();
    @Deprecated
    public static final int COORDINATES_UNIFORM = CoordinateTypes.access$2300();
    @Deprecated
    public static final int COORDINATES_RECTILINEAR = CoordinateTypes.access$2400();

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVolumeReader.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    protected SoVolumeReader() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVolumeReader.ctorImplSync());
        this.customVolumeReader = true;
    }

    private void onGetDataChar() {
        if (this.customVolumeReader) {
            throw new UnsupportedOperationException("Method must be reimplemented.");
        }
    }

    private void onGetSubSlice() {
        if (this.customVolumeReader) {
            throw new UnsupportedOperationException("Method must be reimplemented.");
        }
    }

    private static void notifyGetSubSlice(long l, ByteBuffer byteBuffer, int n, long l2) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        SbBox2i32 sbBox2i32 = new SbBox2i32();
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asIntBuffer().get(sbBox2i32.array);
        SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, l2);
        try {
            soVolumeReader.getSubSlice(sbBox2i32, n, soBufferObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int notifyGetDataChar(long l, ByteBuffer byteBuffer, int[] nArray, ByteBuffer byteBuffer2) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer2.order(ByteOrder.nativeOrder());
            DataInfo dataInfo = soVolumeReader.getDataChar();
            byteBuffer.asFloatBuffer().put(dataInfo.size.array);
            nArray[0] = dataInfo.type.getValue();
            byteBuffer2.asIntBuffer().put(dataInfo.dim.array);
            return dataInfo.readError.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return ReadErrors.RD_UNKNOWN_ERROR.getValue();
        }
    }

    private static int notifyGetNumTimeSteps(long l) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            return soVolumeReader.getNumTimeSteps();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
    }

    private static int notifyGetNumSignificantBits(long l) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            return soVolumeReader.getNumSignificantBits();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    private static boolean notifyIsDataConverted(long l) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            return soVolumeReader.isDataConverted();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static long notifyReadTile(long l, int n, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        SbBox3i32 sbBox3i32 = new SbBox3i32();
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asIntBuffer().get(sbBox3i32.array);
        try {
            SoBufferObject soBufferObject = soVolumeReader.readTile(n, sbBox3i32);
            if (soBufferObject == null) {
                return 0L;
            }
            return soBufferObject.getNativeResourceHandle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    private static boolean notifyGetTileSize(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            SbVec3i32 sbVec3i32 = soVolumeReader.getTileSize();
            if (sbVec3i32 == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asIntBuffer().put(sbVec3i32.array);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static void notifyGetTileMinMax(long l, ByteBuffer byteBuffer, int n) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            SbVec2d sbVec2d = soVolumeReader.getTileMinMax(n);
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asDoubleBuffer().put(sbVec2d.array);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean notifyGetMinMax(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            long[] lArray = soVolumeReader.getMinMax();
            if (lArray == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asLongBuffer().put(lArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyGetIntMinMax(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            int[] nArray = soVolumeReader.getIntMinMax();
            if (nArray == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asIntBuffer().put(nArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyGetDoubleMinMax(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            double[] dArray = soVolumeReader.getDoubleMinMax();
            if (dArray == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asDoubleBuffer().put(dArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyIsThreadSafe(long l) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            return soVolumeReader.isThreadSafe();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyIsRGBA(long l) {
        SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, l);
        try {
            return soVolumeReader.isRGBA();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static native boolean getShortTileSizeImpl(long var0, short[] var2);

    @Deprecated
    public SbVec3s getShortTileSize() {
        SbVec3s sbVec3s = new SbVec3s();
        boolean bl = false;
        ObjectManager.globalLock.lock();
        try {
            bl = SoVolumeReader.getShortTileSizeImpl(this.getNativeResourceHandle(), sbVec3s != null ? sbVec3s.array : null);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        if (bl) {
            return sbVec3s;
        }
        return null;
    }

    private static native boolean getIntMinMaxImpl(long var0, int[] var2, int[] var3);

    private static native int getCoordinateTypeImpl(long var0);

    private static native boolean getTileSizeImpl(long var0, int[] var2);

    private static native boolean isDataConvertedImpl(long var0);

    private static native int getBorderFlagImpl(long var0);

    private static native long readTileImpl(long var0, int var2, int[] var3);

    private static native void setRectilinearCoordinatesImpl(long var0, float[] var2, float[] var3, float[] var4);

    private static native boolean getMinMaxImpl(long var0, long[] var2, long[] var3);

    private static native boolean setDirectCoorSysImpl(long var0, boolean var2);

    private static native String getOriginalFilenameImpl(long var0);

    private static native boolean setDirectCoordSysAutoDetectionImpl(long var0, boolean var2);

    private static native boolean getDoubleMinMaxImpl(long var0, double[] var2, double[] var3);

    private static native boolean getDirectCoordSysAutoDetectionImpl(long var0);

    private static native boolean getDirectCoordSysImpl(long var0);

    private static native int getReaderTypeImpl(long var0);

    private static native boolean isThreadSafeImpl(long var0);

    private static native long getConfiguredWriterImpl(long var0);

    private static native int getNumSubsampledTilesImpl(long var0);

    private static native void getTileMinMaxImpl(long var0, int var2, double[] var3);

    private static native boolean isIgnoredFileImpl(long var0);

    private static native boolean setOutputDataTypeImpl(long var0, boolean var2, int var3);

    private static native int getNumSignificantBitsImpl(long var0);

    private static native int getNumTimeStepsImpl(long var0);

    private static native boolean setInputDataRangeImpl(long var0, boolean var2, double var3, double var5);

    private static native int getDataCharImpl(long var0, float[] var2, int[] var3, int[] var4);

    private static native boolean readTileImpl2(long var0, int var2, long var3, int[] var5);

    private static native long getAppropriateReaderImpl(String var0);

    private static native int setFilenameImpl(long var0, String var2);

    private static native void setRGBAImpl(long var0, boolean var2);

    private static native void getSizeToAllocateImpl(long var0, int[] var2, int[] var3, int[] var4);

    private static native boolean isRGBAImpl(long var0);

    private static native String getFilenameImpl(long var0);

    private static native boolean getSubVolumeInfoImpl(long var0, int[] var2, int[] var3, int[] var4, int[] var5);

    private static native int getCurrentTimeStepImpl(long var0);

    private static native void setCurrentTimeStepImpl(long var0, int var2);

    private static native void restoreAllHandlesImpl(long var0);

    private static native void getNumVoxelsImpl(long var0, int[] var2, int[] var3, int[] var4);

    private static native void closeAllHandlesImpl(long var0);

    private static native void getSubSliceImpl1(long var0, int[] var2, int var3, long var4);

    protected SoVolumeReader(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoBufferObject readTile(int n, SbBox3i32 sbBox3i32) {
        if (this.customVolumeReader) {
            return new SoCpuBufferObject();
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, SoVolumeReader.readTileImpl(this.getNativeResourceHandle(), n, sbBox3i32 != null ? sbBox3i32.array : null));
            return soBufferObject;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isDataConverted() {
        if (this.customVolumeReader) {
            return false;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVolumeReader.isDataConvertedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3i32 getTileSize() {
        if (this.customVolumeReader) {
            return null;
        }
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVolumeReader.getTileSizeImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbVec3i32;
        }
        return null;
    }

    public boolean isIgnoredFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVolumeReader.isIgnoredFileImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumSubsampledTiles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVolumeReader.getNumSubsampledTilesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isThreadSafe() {
        if (this.customVolumeReader) {
            return false;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVolumeReader.isThreadSafeImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOutputDataType(boolean bl, SoDataSet.DataTypes dataTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoVolumeReader.setOutputDataTypeImpl(this.getNativeResourceHandle(), bl, dataTypes.getValue());
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInputDataRange(boolean bl, double d, double d2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoVolumeReader.setInputDataRangeImpl(this.getNativeResourceHandle(), bl, d, d2);
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumSignificantBits() {
        if (this.customVolumeReader) {
            return 0;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVolumeReader.getNumSignificantBitsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public CoordinateTypes getCoordinateType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            CoordinateTypes coordinateTypes = IntegerValuedEnumHelper.fromIntValue(CoordinateTypes.class, SoVolumeReader.getCoordinateTypeImpl(this.getNativeResourceHandle()));
            return coordinateTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoVolumeReader getAppropriateReader(String string) {
        ObjectManager.globalLock.lock();
        try {
            SoVolumeReader soVolumeReader = ObjectManager.getManagedObjectFor(SoVolumeReader.class, SoVolumeReader.getAppropriateReaderImpl(string));
            return soVolumeReader;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataInfo getDataChar() {
        this.onGetDataChar();
        DataInfo dataInfo = new DataInfo();
        SbBox3f sbBox3f = new SbBox3f();
        int[] nArray = new int[1];
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            dataInfo.readError = IntegerValuedEnumHelper.fromIntValue(ReadErrors.class, SoVolumeReader.getDataCharImpl(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null, nArray, sbVec3i32 != null ? sbVec3i32.array : null));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        dataInfo.size = sbBox3f;
        dataInfo.type = IntegerValuedEnumHelper.fromIntValue(SoDataSet.DataTypes.class, nArray[0]);
        dataInfo.dim = sbVec3i32;
        return dataInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3i32 getSizeToAllocate(SbVec3i32 sbVec3i32, SbVec3i32 sbVec3i322) {
        SbVec3i32 sbVec3i323 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.getSizeToAllocateImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbVec3i322 != null ? sbVec3i322.array : null, sbVec3i323.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3i323;
    }

    public int setFilename(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVolumeReader.setFilenameImpl(this.getNativeResourceHandle(), string);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getFilename() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoVolumeReader.getFilenameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSubSlice(SbBox2i32 sbBox2i32, int n, SoBufferObject soBufferObject) {
        this.onGetSubSlice();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.getSubSliceImpl1(this.getNativeResourceHandle(), sbBox2i32 != null ? sbBox2i32.array : null, n, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3i32 getNumVoxels(SbVec3i32 sbVec3i32, SbVec3i32 sbVec3i322) {
        SbVec3i32 sbVec3i323 = new SbVec3i32();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.getNumVoxelsImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbVec3i322 != null ? sbVec3i322.array : null, sbVec3i323.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3i323;
    }

    public String getOriginalFilename() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoVolumeReader.getOriginalFilenameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRGBA(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.setRGBAImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public SubVolumeInfo getSubVolumeInfo(SbBox3i32 sbBox3i32, SbVec3i32 sbVec3i32) {
        SubVolumeInfo subVolumeInfo = new SubVolumeInfo();
        SbVec3i32 sbVec3i322 = new SbVec3i32();
        int[] nArray = new int[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVolumeReader.getSubVolumeInfoImpl(this.getNativeResourceHandle(), sbBox3i32 != null ? sbBox3i32.array : null, sbVec3i32 != null ? sbVec3i32.array : null, sbVec3i322 != null ? sbVec3i322.array : null, nArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            subVolumeInfo.actualSubsampleLevel = sbVec3i322;
            subVolumeInfo.policy = IntegerValuedEnumHelper.fromIntValue(CopyPolicies.class, nArray[0]);
            return subVolumeInfo;
        }
        return null;
    }

    public void closeAllHandles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.closeAllHandlesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public int getBorderFlag() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVolumeReader.getBorderFlagImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isRGBA() {
        if (this.customVolumeReader) {
            return false;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVolumeReader.isRGBAImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public int getNumTimeSteps() {
        if (this.customVolumeReader) {
            return 1;
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVolumeReader.getNumTimeStepsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean readTile(int n, SoBufferObject soBufferObject, SbBox3i32 sbBox3i32) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVolumeReader.readTileImpl2(this.getNativeResourceHandle(), n, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, sbBox3i32 != null ? sbBox3i32.array : null);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public int getCurrentTimeStep() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVolumeReader.getCurrentTimeStepImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void restoreAllHandles() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.restoreAllHandlesImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public void setCurrentTimeStep(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.setCurrentTimeStepImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getDirectCoordSysAutoDetection() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVolumeReader.getDirectCoordSysAutoDetectionImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean setDirectCoorSys(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoVolumeReader.setDirectCoorSysImpl(this.getNativeResourceHandle(), bl);
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean getDirectCoordSys() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVolumeReader.getDirectCoordSysImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getMinMax() {
        if (this.customVolumeReader) {
            return null;
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVolumeReader.getMinMaxImpl(this.getNativeResourceHandle(), lArray, lArray2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            long[] lArray3 = new long[]{lArray[0], lArray2[0]};
            return lArray3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getDoubleMinMax() {
        if (this.customVolumeReader) {
            return null;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVolumeReader.getDoubleMinMaxImpl(this.getNativeResourceHandle(), dArray, dArray2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            double[] dArray3 = new double[]{dArray[0], dArray2[0]};
            return dArray3;
        }
        return null;
    }

    public boolean setDirectCoordSysAutoDetection(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl2 = SoVolumeReader.setDirectCoordSysAutoDetectionImpl(this.getNativeResourceHandle(), bl);
            return bl2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int[] getIntMinMax() {
        if (this.customVolumeReader) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVolumeReader.getIntMinMaxImpl(this.getNativeResourceHandle(), nArray, nArray2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            int[] nArray3 = new int[]{nArray[0], nArray2[0]};
            return nArray3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRectilinearCoordinates(float[] fArray, float[] fArray2, float[] fArray3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.setRectilinearCoordinatesImpl(this.getNativeResourceHandle(), fArray, fArray2, fArray3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2d getTileMinMax(int n) {
        if (this.customVolumeReader) {
            return new SbVec2d(Double.MAX_VALUE, -1.7976931348623157E308);
        }
        SbVec2d sbVec2d = new SbVec2d();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeReader.getTileMinMaxImpl(this.getNativeResourceHandle(), n, sbVec2d.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2d;
    }

    public ReaderTypes getReaderType() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ReaderTypes readerTypes = IntegerValuedEnumHelper.fromIntValue(ReaderTypes.class, SoVolumeReader.getReaderTypeImpl(this.getNativeResourceHandle()));
            return readerTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVolumeWriter getConfiguredWriter() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeWriter soVolumeWriter = ObjectManager.getManagedObjectFor(SoVolumeWriter.class, SoVolumeReader.getConfiguredWriterImpl(this.getNativeResourceHandle()));
            return soVolumeWriter;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static class SubVolumeInfo {
        public SbVec3i32 actualSubsampleLevel;
        public CopyPolicies policy;
        public boolean returnedValue;
    }

    public static class DataInfo {
        public SbBox3f size;
        public SoDataSet.DataTypes type;
        public SbVec3i32 dim;
        public ReadErrors readError;
    }

    public static enum CoordinateTypes implements IntegerValuedEnum
    {
        COORDINATES_UNIFORM(CoordinateTypes.getCOORDINATESUNIFORM()),
        COORDINATES_RECTILINEAR(CoordinateTypes.getCOORDINATESRECTILINEAR());

        private int value;

        private CoordinateTypes(int n2) {
            this.value = n2;
        }

        private static native int getCOORDINATESRECTILINEAR();

        private static native int getCOORDINATESUNIFORM();

        @Deprecated
        public static CoordinateTypes fromValue(int n) {
            return CoordinateTypes.valueOf(n);
        }

        public static CoordinateTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CoordinateTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$2300() {
            return CoordinateTypes.getCOORDINATESUNIFORM();
        }

        static /* synthetic */ int access$2400() {
            return CoordinateTypes.getCOORDINATESRECTILINEAR();
        }
    }

    public static enum ReaderTypes implements IntegerValuedEnum
    {
        NO_READER(ReaderTypes.getNOREADER()),
        AM(ReaderTypes.getAM()),
        AVS(ReaderTypes.getAVS()),
        DICOM(ReaderTypes.getDICOM()),
        GENERIC(ReaderTypes.getGENERIC()),
        LDM(ReaderTypes.getLDM()),
        MEMORY(ReaderTypes.getMEMORY()),
        RASTERSTACK(ReaderTypes.getRASTERSTACK()),
        SEGY(ReaderTypes.getSEGY()),
        VOL(ReaderTypes.getVOL()),
        VOX(ReaderTypes.getVOX()),
        TIFF(ReaderTypes.getTIFF());

        private int value;

        private static native int getVOL();

        private static native int getSEGY();

        private static native int getRASTERSTACK();

        private ReaderTypes(int n2) {
            this.value = n2;
        }

        private static native int getTIFF();

        private static native int getVOX();

        private static native int getMEMORY();

        private static native int getAVS();

        private static native int getAM();

        private static native int getNOREADER();

        private static native int getLDM();

        private static native int getGENERIC();

        private static native int getDICOM();

        @Deprecated
        public static ReaderTypes fromValue(int n) {
            return ReaderTypes.valueOf(n);
        }

        public static ReaderTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ReaderTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$1100() {
            return ReaderTypes.getNOREADER();
        }

        static /* synthetic */ int access$1200() {
            return ReaderTypes.getAM();
        }

        static /* synthetic */ int access$1300() {
            return ReaderTypes.getAVS();
        }

        static /* synthetic */ int access$1400() {
            return ReaderTypes.getDICOM();
        }

        static /* synthetic */ int access$1500() {
            return ReaderTypes.getGENERIC();
        }

        static /* synthetic */ int access$1600() {
            return ReaderTypes.getLDM();
        }

        static /* synthetic */ int access$1700() {
            return ReaderTypes.getMEMORY();
        }

        static /* synthetic */ int access$1800() {
            return ReaderTypes.getRASTERSTACK();
        }

        static /* synthetic */ int access$1900() {
            return ReaderTypes.getSEGY();
        }

        static /* synthetic */ int access$2000() {
            return ReaderTypes.getVOL();
        }

        static /* synthetic */ int access$2100() {
            return ReaderTypes.getVOX();
        }

        static /* synthetic */ int access$2200() {
            return ReaderTypes.getTIFF();
        }
    }

    public static enum CopyPolicies implements IntegerValuedEnum
    {
        COPY(CopyPolicies.getCOPY()),
        NO_COPY(CopyPolicies.getNOCOPY());

        private int value;

        private CopyPolicies(int n2) {
            this.value = n2;
        }

        private static native int getNOCOPY();

        private static native int getCOPY();

        @Deprecated
        public static CopyPolicies fromValue(int n) {
            return CopyPolicies.valueOf(n);
        }

        public static CopyPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CopyPolicies.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$900() {
            return CopyPolicies.getCOPY();
        }

        static /* synthetic */ int access$1000() {
            return CopyPolicies.getNOCOPY();
        }
    }

    public static enum Axis implements IntegerValuedEnum
    {
        X(Axis.getX()),
        Y(Axis.getY()),
        Z(Axis.getZ());

        private int value;

        private static native int getZ();

        private Axis(int n2) {
            this.value = n2;
        }

        private static native int getX();

        private static native int getY();

        @Deprecated
        public static Axis fromValue(int n) {
            return Axis.valueOf(n);
        }

        public static Axis valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Axis.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$600() {
            return Axis.getX();
        }

        static /* synthetic */ int access$700() {
            return Axis.getY();
        }

        static /* synthetic */ int access$800() {
            return Axis.getZ();
        }
    }

    public static enum ReadErrors implements IntegerValuedEnum
    {
        RD_NO_ERROR(ReadErrors.getRDNOERROR()),
        RD_FILE_NOT_FOUND_ERROR(ReadErrors.getRDFILENOTFOUNDERROR()),
        RD_INVALID_DATA_ERROR(ReadErrors.getRDINVALIDDATAERROR()),
        RD_UNSUPPORTED_DATA_TYPE_ERROR(ReadErrors.getRDUNSUPPORTEDDATATYPEERROR()),
        RD_FILE_FORMAT_NOT_VALID_ERROR(ReadErrors.getRDFILEFORMATNOTVALIDERROR()),
        RD_UNKNOWN_ERROR(ReadErrors.getRDUNKNOWNERROR());

        private int value;

        private static native int getRDFILEFORMATNOTVALIDERROR();

        private static native int getRDUNKNOWNERROR();

        private ReadErrors(int n2) {
            this.value = n2;
        }

        private static native int getRDUNSUPPORTEDDATATYPEERROR();

        private static native int getRDNOERROR();

        private static native int getRDFILENOTFOUNDERROR();

        private static native int getRDINVALIDDATAERROR();

        @Deprecated
        public static ReadErrors fromValue(int n) {
            return ReadErrors.valueOf(n);
        }

        public static ReadErrors valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ReadErrors.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return ReadErrors.getRDNOERROR();
        }

        static /* synthetic */ int access$100() {
            return ReadErrors.getRDFILENOTFOUNDERROR();
        }

        static /* synthetic */ int access$200() {
            return ReadErrors.getRDINVALIDDATAERROR();
        }

        static /* synthetic */ int access$300() {
            return ReadErrors.getRDUNSUPPORTEDDATATYPEERROR();
        }

        static /* synthetic */ int access$400() {
            return ReadErrors.getRDFILEFORMATNOTVALIDERROR();
        }

        static /* synthetic */ int access$500() {
            return ReadErrors.getRDUNKNOWNERROR();
        }
    }
}

