/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.meshviz.data;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.graph.PbBase;

public class PbCell
extends PbBase {
    private static native int getNodeIndexImpl(long var0, int var2);

    private static native int getNumNodesImpl(long var0);

    private static native int getNumEdgesImpl(long var0);

    private static native void getNodeCoordImpl(long var0, int var2, float[] var3);

    private static native int getIndexImpl(long var0);

    private static native float getValueImpl2(long var0, float[] var2, float[] var3);

    private static native void getValueImpl1(long var0, float[] var2, Object[] var3, float[] var4);

    private static native void getValueImpl3(long var0, float[] var2, Object[] var3, float[] var4);

    private static native boolean locatePointImpl(long var0, float[] var2, float var3, float[] var4);

    private static native float getValueImpl(long var0, float[] var2, float[] var3);

    private static native int getNumFacetsImpl(long var0);

    private static native void getBoundsImpl(long var0, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6, float[] var7);

    private static native float getLongestEdgeLengthImpl(long var0);

    private static native void getCenterImpl(long var0, float[] var2);

    private static native float getVolumeImpl(long var0);

    private static native void getBoundingBoxImpl(long var0, float[] var2);

    private static native float getAreaImpl(long var0);

    protected PbCell(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public float getLongestEdgeLength() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = PbCell.getLongestEdgeLengthImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getValue(float[] fArray, float[] fArray2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = PbCell.getValueImpl2(this.getNativeResourceHandle(), fArray, fArray2);
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3f getValue(float[] fArray, SbVec3f[] sbVec3fArray) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbCell.getValueImpl3(this.getNativeResourceHandle(), fArray, sbVec3fArray, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public int getNumFacets() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbCell.getNumFacetsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumNodes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbCell.getNumNodesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumEdges() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbCell.getNumEdgesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f getCenter() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbCell.getCenterImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SbVec3f getNodeCoord(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbCell.getNodeCoordImpl(this.getNativeResourceHandle(), n, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public float getVolume() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = PbCell.getVolumeImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNodeIndex(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = PbCell.getNodeIndexImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getValue(SbVec3f sbVec3f, float[] fArray) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = PbCell.getValueImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, fArray);
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbBox3f getBoundingBox() {
        SbBox3f sbBox3f = new SbBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbCell.getBoundingBoxImpl(this.getNativeResourceHandle(), sbBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbBox3f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3f getValue(SbVec3f sbVec3f, SbVec3f[] sbVec3fArray) {
        SbVec3f sbVec3f2 = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbCell.getValueImpl1(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, sbVec3fArray, sbVec3f2.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f2;
    }

    public int getIndex() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbCell.getIndexImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3f locatePoint(SbVec3f sbVec3f, float f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = PbCell.locatePointImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f, sbVec3f2 != null ? sbVec3f2.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbVec3f2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getBounds() {
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        float[] fArray3 = new float[1];
        float[] fArray4 = new float[1];
        float[] fArray5 = new float[1];
        float[] fArray6 = new float[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbCell.getBoundsImpl(this.getNativeResourceHandle(), fArray, fArray2, fArray3, fArray4, fArray5, fArray6);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        float[] fArray7 = new float[]{fArray[0], fArray2[0], fArray3[0], fArray4[0], fArray5[0], fArray6[0]};
        return fArray7;
    }

    public float getArea() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = PbCell.getAreaImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

