/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.meshviz.data;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.meshviz.data.PbCell;
import com.openinventor.meshviz.graph.PbBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class PbMesh
extends PbBase {
    @Deprecated
    public static final int PER_CELL = DataBindings.access$000();
    @Deprecated
    public static final int PER_NODE = DataBindings.access$100();

    private static native void removeAllStringsSetImpl(long var0);

    private static native void removeAllValuesSetImpl(long var0);

    private static native boolean removeVecsSetImpl(long var0, int var2);

    private static native void getCoordinatesImpl(long var0, Object[] var2, Object[] var3, Object[] var4);

    private static native int getNumValuesSetImpl(long var0);

    private static native void setCoordinatesImpl(long var0, float[] var2, float[] var3, float[] var4);

    private static native void removeAllVecsSetImpl(long var0);

    private static native float[] getValuesSetImpl(long var0, int var2);

    private static native Object getDirectValuesSetImpl(long var0, int var2);

    private static native Object getDirectVecsSetImpl(long var0, int var2);

    private static native boolean removeStringsSetImpl(long var0, int var2);

    private static native boolean removeValuesSetImpl(long var0, int var2);

    private static native long getVecsSetImpl(long var0, int var2);

    private static native long findContainingCellImpl1(long var0, float[] var2, float var3, float[] var4);

    private static native void getSmallestCellBoxImpl(long var0, int[] var2, float[] var3);

    private static native boolean getMaxValuesSetImpl(long var0, int var2, float[] var3);

    private static native void getBiggestCellBoxImpl(long var0, int[] var2, float[] var3);

    private static native boolean getMaxVecsSetImpl(long var0, int var2, float[] var3);

    private static native long getCellImpl(long var0, int var2);

    private static native int getNumVecsSetImpl(long var0);

    private static native long findContainingCellImpl(long var0, float[] var2, float var3, float[] var4, long var5);

    private static native int getNumStringsSetImpl(long var0);

    private static native float getAreaImpl(long var0);

    private static native boolean getMinVecsSetImpl(long var0, int var2, float[] var3);

    private static native float getVolumeImpl(long var0);

    private static native boolean getMinValuesSetImpl(long var0, int var2, float[] var3);

    private static native boolean isDataDuplicatedImpl(long var0);

    private static native void addVecsSetImpl(long var0, int var2, Object[] var3, String var4);

    private static native String getValuesSetNameImpl(long var0, int var2);

    private static native void getBoundingBoxImpl(long var0, float[] var2);

    private static native void addValuesSetImpl1(long var0, int var2, float[] var3, int var4, String var5);

    private static native int getValuesBindingImpl(long var0, int var2);

    private static native void addValuesSetImpl(long var0, int var2, float[] var3, String var4);

    private static native void addStringsSetImpl(long var0, int var2, String[] var3, String var4);

    private static native int getNumCellsImpl(long var0);

    private static native int getNumNodesImpl(long var0);

    private static native String getVecsSetNameImpl(long var0, int var2);

    private static native String getStringsSetNameImpl(long var0, int var2);

    private static native void getNodeCoordImpl(long var0, int var2, float[] var3);

    protected PbMesh(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void addValuesSet(int n, float[] fArray) {
        this.addValuesSet(n, fArray, "");
    }

    public void addValuesSet(int n, float[] fArray, DataBindings dataBindings) {
        this.addValuesSet(n, fArray, dataBindings, "");
    }

    public void addStringsSet(int n, String[] stringArray) {
        this.addStringsSet(n, stringArray, "");
    }

    public void addVecsSet(int n, SbVec3f[] sbVec3fArray) {
        this.addVecsSet(n, sbVec3fArray, "");
    }

    public String getStringsSetName(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = PbMesh.getStringsSetNameImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getVecsSetName(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = PbMesh.getVecsSetNameImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVecsSet(int n, SbVec3f[] sbVec3fArray, String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.addVecsSetImpl(this.getNativeResourceHandle(), n, sbVec3fArray, string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getValuesSetName(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = PbMesh.getValuesSetNameImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectValuesSet(int n) {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)PbMesh.getDirectValuesSetImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbVec3f[] getVecsSet(int n) {
        long l = Inventor.ZeroHandle;
        this.acquireLock(ObjectManager.globalLock);
        try {
            l = PbMesh.getVecsSetImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return SbVec3f.toArray(l, this.getNumNodes());
    }

    public boolean removeValuesSet(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = PbMesh.removeValuesSetImpl(this.getNativeResourceHandle(), n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FloatBuffer getDirectVecsSet(int n) {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)PbMesh.getDirectVecsSetImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public float[] getValuesSet(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float[] fArray = PbMesh.getValuesSetImpl(this.getNativeResourceHandle(), n);
            return fArray;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f getNodeCoord(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.getNodeCoordImpl(this.getNativeResourceHandle(), n, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public SbBox3f getBoundingBox() {
        SbBox3f sbBox3f = new SbBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.getBoundingBoxImpl(this.getNativeResourceHandle(), sbBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbBox3f;
    }

    public int getNumCells() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbMesh.getNumCellsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMinValuesSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = PbMesh.getMinValuesSetImpl(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    public int getNumNodes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbMesh.getNumNodesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public DataBindings getValuesBinding(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            DataBindings dataBindings = IntegerValuedEnumHelper.fromIntValue(DataBindings.class, PbMesh.getValuesBindingImpl(this.getNativeResourceHandle(), n));
            return dataBindings;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStringsSet(int n, String[] stringArray, String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.addStringsSetImpl(this.getNativeResourceHandle(), n, stringArray, string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValuesSet(int n, float[] fArray, DataBindings dataBindings, String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.addValuesSetImpl1(this.getNativeResourceHandle(), n, fArray, dataBindings.getValue(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isDataDuplicated() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = PbMesh.isDataDuplicatedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValuesSet(int n, float[] fArray, String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.addValuesSetImpl(this.getNativeResourceHandle(), n, fArray, string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean removeStringsSet(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = PbMesh.removeStringsSetImpl(this.getNativeResourceHandle(), n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMaxValuesSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = PbMesh.getMaxValuesSetImpl(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellBox getBiggestCellBox() {
        CellBox cellBox = new CellBox();
        int[] nArray = new int[1];
        SbBox3f sbBox3f = new SbBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.getBiggestCellBoxImpl(this.getNativeResourceHandle(), nArray, sbBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        cellBox.bbox = sbBox3f;
        cellBox.cell_index = nArray[0];
        return cellBox;
    }

    public float getVolume() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = PbMesh.getVolumeImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getArea() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = PbMesh.getAreaImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMinVecsSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = PbMesh.getMinVecsSetImpl(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMaxVecsSet(int n) {
        float[] fArray = new float[1];
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = PbMesh.getMaxVecsSetImpl(this.getNativeResourceHandle(), n, fArray);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return fArray[0];
        }
        throw new IllegalArgumentException();
    }

    public PbCell getCell(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbCell pbCell = ObjectManager.getManagedObjectFor(PbCell.class, PbMesh.getCellImpl(this.getNativeResourceHandle(), n));
            return pbCell;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellBox getSmallestCellBox() {
        CellBox cellBox = new CellBox();
        int[] nArray = new int[1];
        SbBox3f sbBox3f = new SbBox3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.getSmallestCellBoxImpl(this.getNativeResourceHandle(), nArray, sbBox3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        cellBox.bbox = sbBox3f;
        cellBox.cell_index = nArray[0];
        return cellBox;
    }

    public void removeAllVecsSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.removeAllVecsSetImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinatesInfo getCoordinates() {
        CoordinatesInfo coordinatesInfo = new CoordinatesInfo();
        Object[] objectArray = new ByteBuffer[1];
        Object[] objectArray2 = new ByteBuffer[1];
        Object[] objectArray3 = new ByteBuffer[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.getCoordinatesImpl(this.getNativeResourceHandle(), objectArray, objectArray2, objectArray3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (objectArray[0] != null) {
            ((ByteBuffer)objectArray[0]).order(ByteOrder.nativeOrder());
        }
        if (objectArray2[0] != null) {
            ((ByteBuffer)objectArray2[0]).order(ByteOrder.nativeOrder());
        }
        if (objectArray3[0] != null) {
            ((ByteBuffer)objectArray3[0]).order(ByteOrder.nativeOrder());
        }
        coordinatesInfo.xnod = objectArray[0] != null ? ((ByteBuffer)objectArray[0]).asFloatBuffer() : null;
        coordinatesInfo.ynod = objectArray2[0] != null ? ((ByteBuffer)objectArray2[0]).asFloatBuffer() : null;
        coordinatesInfo.znod = objectArray3[0] != null ? ((ByteBuffer)objectArray3[0]).asFloatBuffer() : null;
        return coordinatesInfo;
    }

    public void removeAllStringsSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.removeAllStringsSetImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean removeVecsSet(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = PbMesh.removeVecsSetImpl(this.getNativeResourceHandle(), n);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeAllValuesSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.removeAllValuesSetImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumValuesSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbMesh.getNumValuesSetImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumVecsSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbMesh.getNumVecsSetImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainingCell findContainingCell(SbVec3f sbVec3f, float f, PbCell pbCell) {
        ContainingCell containingCell = new ContainingCell();
        SbVec3f sbVec3f2 = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            containingCell.cell = ObjectManager.getManagedObjectFor(PbCell.class, PbMesh.findContainingCellImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f, sbVec3f2 != null ? sbVec3f2.array : null, pbCell != null ? pbCell.getNativeResourceHandle() : Inventor.ZeroHandle));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        containingCell.pcoord = sbVec3f2;
        return containingCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainingCell findContainingCell(SbVec3f sbVec3f, float f) {
        ContainingCell containingCell = new ContainingCell();
        SbVec3f sbVec3f2 = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            containingCell.cell = ObjectManager.getManagedObjectFor(PbCell.class, PbMesh.findContainingCellImpl1(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, f, sbVec3f2 != null ? sbVec3f2.array : null));
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        containingCell.pcoord = sbVec3f2;
        return containingCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoordinates(float[] fArray, float[] fArray2, float[] fArray3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbMesh.setCoordinatesImpl(this.getNativeResourceHandle(), fArray, fArray2, fArray3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumStringsSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = PbMesh.getNumStringsSetImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static class CoordinatesInfo {
        public FloatBuffer xnod;
        public FloatBuffer ynod;
        public FloatBuffer znod;
    }

    public static class ContainingCell {
        public SbVec3f pcoord;
        public PbCell cell;
    }

    public static class CellBox {
        public int cell_index;
        public SbBox3f bbox;
    }

    public static enum DataBindings implements IntegerValuedEnum
    {
        PER_CELL(DataBindings.getPERCELL()),
        PER_NODE(DataBindings.getPERNODE());

        private int value;

        private DataBindings(int n2) {
            this.value = n2;
        }

        private static native int getPERNODE();

        private static native int getPERCELL();

        @Deprecated
        public static DataBindings fromValue(int n) {
            return DataBindings.valueOf(n);
        }

        public static DataBindings valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DataBindings.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return DataBindings.getPERCELL();
        }

        static /* synthetic */ int access$100() {
            return DataBindings.getPERNODE();
        }
    }
}

