/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.meshviz.elements;

import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox2f;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.elements.SoReplacedElement;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.meshviz.nodes.PoProfile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class PoProfileElement
extends SoReplacedElement {
    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = PoProfileElement.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getDefaultImpl();

    private static native void getBBoxImpl(long var0, float[] var2);

    private static native Object getDirectProfileImpl(long var0, float var2, int[] var3);

    private static native int initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5);

    private static native void nativeDerivedClassInit();

    private static native long ctorImpl();

    private static native long getImpl(long var0);

    private static native long getProfileImpl(long var0, float var2, int[] var3);

    private static native void setImpl(long var0, long var2, long var4);

    private static native int getClassStackIndexImpl();

    protected PoProfileElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected PoProfileElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    protected PoProfileElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, PoProfileElement.ctorImplSync());
        Class<?> clazz = this.getClass();
        int n = PoProfileElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz));
        ElementManager.saveClassStackIndex(clazz, n);
    }

    public static SbBox2f getBBox(SoState soState) {
        SbBox2f sbBox2f = new SbBox2f();
        ObjectManager.globalLock.lock();
        try {
            PoProfileElement.getBBoxImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbBox2f.array);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return sbBox2f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SbVec2f[] getProfile(SoState soState, float f) {
        int[] nArray = new int[1];
        long l = Inventor.ZeroHandle;
        ObjectManager.globalLock.lock();
        try {
            l = PoProfileElement.getProfileImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, f, nArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        return SbVec2f.toArray(l, nArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FloatBuffer getDirectProfile(SoState soState, float f) {
        int[] nArray = new int[1];
        ByteBuffer byteBuffer = null;
        ObjectManager.globalLock.lock();
        try {
            byteBuffer = (ByteBuffer)PoProfileElement.getDirectProfileImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, f, nArray);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public static PoProfile get(SoState soState) {
        ObjectManager.globalLock.lock();
        try {
            PoProfile poProfile = ObjectManager.getManagedObjectFor(PoProfile.class, PoProfileElement.getImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle));
            return poProfile;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    @Deprecated
    public static int getClassStackIndex() {
        ObjectManager.globalLock.lock();
        try {
            int n = PoProfileElement.getClassStackIndexImpl();
            return n;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static PoProfile getDefault() {
        ObjectManager.globalLock.lock();
        try {
            PoProfile poProfile = ObjectManager.getManagedObjectFor(PoProfile.class, PoProfileElement.getDefaultImpl());
            return poProfile;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void set(SoState soState, SoNode soNode, PoProfile poProfile) {
        ObjectManager.globalLock.lock();
        try {
            PoProfileElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, poProfile != null ? poProfile.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    static {
        PoProfileElement.nativeDerivedClassInit();
    }
}

