/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.meshviz.graph;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.nodekits.SoBaseKit;
import com.openinventor.inventor.nodekits.SoNodekitCatalog;
import com.openinventor.meshviz.graph.PbDomain;
import com.openinventor.meshviz.misc.callbacks.PoRebuildCB;

public class PoBase
extends SoBaseKit {
    private static boolean s_checklic = true;
    @Deprecated
    public static final int UPDATE_METHOD_IMMEDIATE = UpdateMethodTypes.access$000();
    @Deprecated
    public static final int UPDATE_METHOD_ON_ACTION = UpdateMethodTypes.access$100();
    @Deprecated
    public static final int FOLD_NODE_WRITE_FORMAT = NodeWriteFormats.access$200();
    @Deprecated
    public static final int UNFOLD_NODE_WRITE_FORMAT = NodeWriteFormats.access$300();
    @Deprecated
    public static final int SO_TEXT3 = TextTypes.access$400();
    @Deprecated
    public static final int SO_ANNO_TEXT3 = TextTypes.access$500();
    private PbDomain m_dom_setDomain;

    public void addPreRebuildCallback(PoRebuildCB poRebuildCB, Object object) {
        PoBase.addPreRebuildCallbackImpl(this.getNativeResourceHandle(), poRebuildCB, object);
    }

    private static native void addPreRebuildCallbackImpl(long var0, PoRebuildCB var2, Object var3);

    public void addPostRebuildCallback(PoRebuildCB poRebuildCB, Object object) {
        PoBase.addPostRebuildCallbackImpl(this.getNativeResourceHandle(), poRebuildCB, object);
    }

    private static native void addPostRebuildCallbackImpl(long var0, PoRebuildCB var2, Object var3);

    private static native void rebuildImpl(long var0);

    private static native void setUpdateMethodImpl(long var0, int var2);

    private static native boolean isVRML2ModeImpl();

    private static native int getTextTypeImpl();

    private static native void setVRML2ModeImpl(boolean var0);

    private static native boolean isModifiedImpl(long var0);

    private static native boolean isBuiltImpl(long var0);

    private static native long getDomainImpl(long var0);

    private static native int getUpdateMethodImpl(long var0);

    private static native void setDomainImpl(long var0, long var2);

    private static native long getClassNodekitCatalogImpl();

    private static native int getNodeWriteFormatImpl();

    private static native void setNodeWriteFormatImpl(int var0);

    private static native void touchKitImpl(long var0);

    private static native void setTextTypeImpl(int var0);

    protected PoBase(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        if (s_checklic) {
            Inventor.checkMVizLP();
            s_checklic = false;
        }
        this.initializeFields();
    }

    static native String getClassTypeId();

    public static void setTextType(TextTypes textTypes) {
        ObjectManager.globalLock.lock();
        try {
            PoBase.setTextTypeImpl(textTypes.getValue());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static TextTypes getTextType() {
        ObjectManager.globalLock.lock();
        try {
            TextTypes textTypes = IntegerValuedEnumHelper.fromIntValue(TextTypes.class, PoBase.getTextTypeImpl());
            return textTypes;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setVRML2Mode(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            PoBase.setVRML2ModeImpl(bl);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static NodeWriteFormats getNodeWriteFormat() {
        ObjectManager.globalLock.lock();
        try {
            NodeWriteFormats nodeWriteFormats = IntegerValuedEnumHelper.fromIntValue(NodeWriteFormats.class, PoBase.getNodeWriteFormatImpl());
            return nodeWriteFormats;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public boolean isBuilt() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = PoBase.isBuiltImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static SoNodekitCatalog getClassNodekitCatalog() {
        ObjectManager.globalLock.lock();
        try {
            SoNodekitCatalog soNodekitCatalog = ObjectManager.getManagedObjectFor(SoNodekitCatalog.class, PoBase.getClassNodekitCatalogImpl());
            return soNodekitCatalog;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static void setNodeWriteFormat(NodeWriteFormats nodeWriteFormats) {
        ObjectManager.globalLock.lock();
        try {
            PoBase.setNodeWriteFormatImpl(nodeWriteFormats.getValue());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public static boolean isVRML2Mode() {
        ObjectManager.globalLock.lock();
        try {
            boolean bl = PoBase.isVRML2ModeImpl();
            return bl;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void setDomain(PbDomain pbDomain) {
        this.m_dom_setDomain = pbDomain;
        this.acquireLock(ObjectManager.globalLock);
        try {
            PoBase.setDomainImpl(this.getNativeResourceHandle(), pbDomain != null ? pbDomain.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public PbDomain getDomain() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PbDomain pbDomain = ObjectManager.getManagedObjectFor(PbDomain.class, PoBase.getDomainImpl(this.getNativeResourceHandle()));
            return pbDomain;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void touchKit() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PoBase.touchKitImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public UpdateMethodTypes getUpdateMethod() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            UpdateMethodTypes updateMethodTypes = IntegerValuedEnumHelper.fromIntValue(UpdateMethodTypes.class, PoBase.getUpdateMethodImpl(this.getNativeResourceHandle()));
            return updateMethodTypes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isModified() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = PoBase.isModifiedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void rebuild() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PoBase.rebuildImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setUpdateMethod(UpdateMethodTypes updateMethodTypes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            PoBase.setUpdateMethodImpl(this.getNativeResourceHandle(), updateMethodTypes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static enum TextTypes implements IntegerValuedEnum
    {
        SO_TEXT3(TextTypes.getSOTEXT3()),
        SO_ANNO_TEXT3(TextTypes.getSOANNOTEXT3());

        private int value;

        private TextTypes(int n2) {
            this.value = n2;
        }

        private static native int getSOANNOTEXT3();

        private static native int getSOTEXT3();

        @Deprecated
        public static TextTypes fromValue(int n) {
            return TextTypes.valueOf(n);
        }

        public static TextTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(TextTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$400() {
            return TextTypes.getSOTEXT3();
        }

        static /* synthetic */ int access$500() {
            return TextTypes.getSOANNOTEXT3();
        }
    }

    public static enum NodeWriteFormats implements IntegerValuedEnum
    {
        FOLD_NODE_WRITE_FORMAT(NodeWriteFormats.getFOLDNODEWRITEFORMAT()),
        UNFOLD_NODE_WRITE_FORMAT(NodeWriteFormats.getUNFOLDNODEWRITEFORMAT());

        private int value;

        private NodeWriteFormats(int n2) {
            this.value = n2;
        }

        private static native int getUNFOLDNODEWRITEFORMAT();

        private static native int getFOLDNODEWRITEFORMAT();

        @Deprecated
        public static NodeWriteFormats fromValue(int n) {
            return NodeWriteFormats.valueOf(n);
        }

        public static NodeWriteFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(NodeWriteFormats.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$200() {
            return NodeWriteFormats.getFOLDNODEWRITEFORMAT();
        }

        static /* synthetic */ int access$300() {
            return NodeWriteFormats.getUNFOLDNODEWRITEFORMAT();
        }
    }

    public static enum UpdateMethodTypes implements IntegerValuedEnum
    {
        UPDATE_METHOD_IMMEDIATE(UpdateMethodTypes.getUPDATEMETHODIMMEDIATE()),
        UPDATE_METHOD_ON_ACTION(UpdateMethodTypes.getUPDATEMETHODONACTION());

        private int value;

        private UpdateMethodTypes(int n2) {
            this.value = n2;
        }

        private static native int getUPDATEMETHODONACTION();

        private static native int getUPDATEMETHODIMMEDIATE();

        @Deprecated
        public static UpdateMethodTypes fromValue(int n) {
            return UpdateMethodTypes.valueOf(n);
        }

        public static UpdateMethodTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(UpdateMethodTypes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return UpdateMethodTypes.getUPDATEMETHODIMMEDIATE();
        }

        static /* synthetic */ int access$100() {
            return UpdateMethodTypes.getUPDATEMETHODONACTION();
        }
    }
}

