/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.clients.nodes;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.fields.SoMFEnum;
import com.openinventor.inventor.fields.SoMFVec2String;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.fields.SoSFUShort;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.touch.events.SoTouchEvent;

public class SoRemoteVizClient
extends SoNode {
    @Deprecated
    public static final int STRETCH = DisplayModes.access$2800();
    @Deprecated
    public static final int CROP = DisplayModes.access$2900();
    @Deprecated
    public static final int FIT = DisplayModes.access$3000();
    @Deprecated
    public static final int NONE = VideoDecoderType.access$3100();
    @Deprecated
    public static final int OPENH264 = VideoDecoderType.access$3200();
    @Deprecated
    public static final int INTEL_QUICKSYNC = VideoDecoderType.access$3300();
    @Deprecated
    public static final int NVDECODE = VideoDecoderType.access$3400();
    @Deprecated
    public static final int UNKNOWN = StreamingModes.access$3500();
    @Deprecated
    public static final int IMAGE = StreamingModes.access$3600();
    @Deprecated
    public static final int VIDEO = StreamingModes.access$3700();
    @Deprecated
    public static final int SSLv2 = SecurityProtocols.access$3800();
    @Deprecated
    public static final int SSLv3 = SecurityProtocols.access$3900();
    @Deprecated
    public static final int TLSv1 = SecurityProtocols.access$4000();
    @Deprecated
    public static final int TLSv1_1 = SecurityProtocols.access$4100();
    @Deprecated
    public static final int TLSv1_2 = SecurityProtocols.access$4200();
    public final SoSFBool connect;
    public final SoSFString ipAddress;
    public final SoSFUShort port;
    public final SoSFString renderAreaName;
    public final SoMFEnum<VideoDecoderType> videoDecoders;
    public final SoMFVec2String connectionParameters;
    public final SoSFEnum<DisplayModes> displayMode;
    public final SbEventHandler<ServiceMessageEventArg> onServiceMessage;
    public final SbEventHandler<MessageEventArg> onReceivedMessage;
    public final SbEventHandler<RenderAreaSizeEventArg> onRenderAreaResize;
    public final SbEventHandler<FrameEventArg> onReceivedFrame;
    public final SbEventHandler<FrameEventArg> onDecodedFrame;
    public final SbEventHandler<MouseLocationEventArg> onMouseLocationEvent;
    public final SbEventHandler<MouseButtonEventArg> onMouseButtonEvent;
    public final SbEventHandler<MouseWheelEventArg> onMouseWheelEvent;
    public final SbEventHandler<KeyboardEventArg> onKeyboardEvent;
    public final SbEventHandler<TouchEventArg> onTouchEvent;

    private static native int getVideoDecoderImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoRemoteVizClient.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long addOnTouchEventEventHandler(long var0, OnTouchEventEventHandler var2, String var3);

    private static native boolean removeOnKeyboardEventEventHandler(long var0, long var2);

    private static native int getStreamingModeImpl(long var0);

    private static native boolean removeOnTouchEventEventHandler(long var0, long var2);

    private static native void sendMessageImpl(long var0, String var2);

    private static native void requestRenderAreaSizeImpl(long var0, short[] var2);

    private static native boolean isSecureConnectionImpl(long var0);

    private static native void getRenderAreaSizeImpl(long var0, short[] var2);

    private static native void getContainerSizeImpl(long var0, short[] var2);

    private static native void enableSecureConnectionImpl(long var0, String var2, String var3, int var4, String var5);

    private static native boolean isVideoStreamingSupportedImpl(long var0);

    private static native boolean isImageStreamingSupportedImpl(long var0);

    private static native int getEnabledSecurityProtocolsImpl(long var0);

    private static native long addOnKeyboardEventEventHandler(long var0, OnKeyboardEventEventHandler var2, String var3);

    private static native boolean removeOnRenderAreaResizeEventHandler(long var0, long var2);

    private static native long addOnRenderAreaResizeEventHandler(long var0, OnRenderAreaResizeEventHandler var2, String var3);

    private static native boolean removeOnReceivedFrameEventHandler(long var0, long var2);

    private static native long addOnReceivedFrameEventHandler(long var0, OnReceivedFrameEventHandler var2, String var3);

    private static native boolean removeOnReceivedMessageEventHandler(long var0, long var2);

    private static native long addOnServiceMessageEventHandler(long var0, OnServiceMessageEventHandler var2, String var3);

    private static native long ctorImpl();

    private static native long addOnReceivedMessageEventHandler(long var0, OnReceivedMessageEventHandler var2, String var3);

    private static native boolean removeOnServiceMessageEventHandler(long var0, long var2);

    private static native long addOnMouseButtonEventEventHandler(long var0, OnMouseButtonEventEventHandler var2, String var3);

    private static native boolean removeOnMouseLocationEventEventHandler(long var0, long var2);

    private static native boolean removeOnMouseButtonEventEventHandler(long var0, long var2);

    private static native boolean removeOnMouseWheelEventEventHandler(long var0, long var2);

    private static native long addOnMouseWheelEventEventHandler(long var0, OnMouseWheelEventEventHandler var2, String var3);

    private static native boolean removeOnDecodedFrameEventHandler(long var0, long var2);

    private static native long addOnMouseLocationEventEventHandler(long var0, OnMouseLocationEventEventHandler var2, String var3);

    private static native long addOnDecodedFrameEventHandler(long var0, OnDecodedFrameEventHandler var2, String var3);

    protected SoRemoteVizClient(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.connect = ObjectManager.getManagedObjectFor(SoSFBool.class, SoRemoteVizClient.getFieldHandle(this.getNativeResourceHandle(), "connect"));
        this.ipAddress = ObjectManager.getManagedObjectFor(SoSFString.class, SoRemoteVizClient.getFieldHandle(this.getNativeResourceHandle(), "ipAddress"));
        this.port = ObjectManager.getManagedObjectFor(SoSFUShort.class, SoRemoteVizClient.getFieldHandle(this.getNativeResourceHandle(), "port"));
        this.renderAreaName = ObjectManager.getManagedObjectFor(SoSFString.class, SoRemoteVizClient.getFieldHandle(this.getNativeResourceHandle(), "renderAreaName"));
        this.videoDecoders = ObjectManager.getManagedObjectFor(SoMFEnum.class, SoRemoteVizClient.getFieldHandle(this.getNativeResourceHandle(), "videoDecoders"), VideoDecoderType.class);
        this.connectionParameters = ObjectManager.getManagedObjectFor(SoMFVec2String.class, SoRemoteVizClient.getFieldHandle(this.getNativeResourceHandle(), "connectionParameters"));
        this.displayMode = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoRemoteVizClient.getFieldHandle(this.getNativeResourceHandle(), "displayMode"), DisplayModes.class);
        this.onServiceMessage = new OnServiceMessageEventHandler();
        this.onReceivedMessage = new OnReceivedMessageEventHandler();
        this.onRenderAreaResize = new OnRenderAreaResizeEventHandler();
        this.onReceivedFrame = new OnReceivedFrameEventHandler();
        this.onDecodedFrame = new OnDecodedFrameEventHandler();
        this.onMouseLocationEvent = new OnMouseLocationEventEventHandler();
        this.onMouseButtonEvent = new OnMouseButtonEventEventHandler();
        this.onMouseWheelEvent = new OnMouseWheelEventEventHandler();
        this.onKeyboardEvent = new OnKeyboardEventEventHandler();
        this.onTouchEvent = new OnTouchEventEventHandler();
    }

    static native String getClassTypeId();

    public void enableSecureConnection(String string, String string2) {
        this.enableSecureConnection(string, string2, SecurityProtocols.valueOf(SecurityProtocols.TLSv1.getValue() | SecurityProtocols.TLSv1_1.getValue() | SecurityProtocols.TLSv1_2.getValue()), "");
    }

    public void enableSecureConnection(String string, String string2, SecurityProtocols securityProtocols) {
        this.enableSecureConnection(string, string2, securityProtocols, "");
    }

    public void sendMessage(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRemoteVizClient.sendMessageImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSecureConnection(String string, String string2, SecurityProtocols securityProtocols, String string3) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRemoteVizClient.enableSecureConnectionImpl(this.getNativeResourceHandle(), string, string2, securityProtocols.getValue(), string3);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoRemoteVizClient() {
        this(Inventor.ConstructorCommand.CreateInstance, SoRemoteVizClient.ctorImplSync());
    }

    public boolean isSecureConnection() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoRemoteVizClient.isSecureConnectionImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SecurityProtocols getEnabledSecurityProtocols() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SecurityProtocols securityProtocols = IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, SoRemoteVizClient.getEnabledSecurityProtocolsImpl(this.getNativeResourceHandle()));
            return securityProtocols;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isImageStreamingSupported() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoRemoteVizClient.isImageStreamingSupportedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isVideoStreamingSupported() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoRemoteVizClient.isVideoStreamingSupportedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public VideoDecoderType getVideoDecoder() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            VideoDecoderType videoDecoderType = IntegerValuedEnumHelper.fromIntValue(VideoDecoderType.class, SoRemoteVizClient.getVideoDecoderImpl(this.getNativeResourceHandle()));
            return videoDecoderType;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2s getContainerSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRemoteVizClient.getContainerSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    public StreamingModes getStreamingMode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            StreamingModes streamingModes = IntegerValuedEnumHelper.fromIntValue(StreamingModes.class, SoRemoteVizClient.getStreamingModeImpl(this.getNativeResourceHandle()));
            return streamingModes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void requestRenderAreaSize(SbVec2s sbVec2s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRemoteVizClient.requestRenderAreaSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec2s getRenderAreaSize() {
        SbVec2s sbVec2s = new SbVec2s();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoRemoteVizClient.getRenderAreaSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec2s;
    }

    private class OnTouchEventEventHandler
    extends SbEventHandler<TouchEventArg> {
        private OnTouchEventEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnTouchEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = TouchEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnTouchEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnKeyboardEventEventHandler
    extends SbEventHandler<KeyboardEventArg> {
        private OnKeyboardEventEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnKeyboardEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = KeyboardEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnKeyboardEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnMouseWheelEventEventHandler
    extends SbEventHandler<MouseWheelEventArg> {
        private OnMouseWheelEventEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnMouseWheelEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = MouseWheelEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnMouseWheelEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnMouseButtonEventEventHandler
    extends SbEventHandler<MouseButtonEventArg> {
        private OnMouseButtonEventEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnMouseButtonEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = MouseButtonEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnMouseButtonEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnMouseLocationEventEventHandler
    extends SbEventHandler<MouseLocationEventArg> {
        private OnMouseLocationEventEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnMouseLocationEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = MouseLocationEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnMouseLocationEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnDecodedFrameEventHandler
    extends SbEventHandler<FrameEventArg> {
        private OnDecodedFrameEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnDecodedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = FrameEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnDecodedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnReceivedFrameEventHandler
    extends SbEventHandler<FrameEventArg> {
        private OnReceivedFrameEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnReceivedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = FrameEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnReceivedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnRenderAreaResizeEventHandler
    extends SbEventHandler<RenderAreaSizeEventArg> {
        private OnRenderAreaResizeEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnRenderAreaResizeEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = RenderAreaSizeEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnRenderAreaResizeEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnReceivedMessageEventHandler
    extends SbEventHandler<MessageEventArg> {
        private OnReceivedMessageEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnReceivedMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = MessageEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnReceivedMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    private class OnServiceMessageEventHandler
    extends SbEventHandler<ServiceMessageEventArg> {
        private OnServiceMessageEventHandler() {
        }

        @Override
        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnServiceMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }

        @Override
        protected void addNativeEventHandler() {
            String string = ServiceMessageEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnServiceMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }
    }

    public static class FrameEventArg
    extends Inventor
    implements SbEventArg {
        private static native boolean isLosslessImpl(long var0);

        private static native long getSourceImpl(long var0);

        private static native long getDataLengthImpl(long var0);

        private static native long getIdImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2, long var4, boolean var6, String var7);

        private static native String getMessageImpl(long var0);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected FrameEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public FrameEventArg(SoRemoteVizClient soRemoteVizClient, long l, long l2, boolean bl, String string) {
            this(Inventor.ConstructorCommand.CreateInstance, FrameEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, l, l2, bl, string));
        }

        public void setValue(FrameEventArg frameEventArg) {
            FrameEventArg.setValueImpl(this.getNativeResourceHandle(), frameEventArg.getNativeResourceHandle());
        }

        public long getDataLength() {
            return FrameEventArg.getDataLengthImpl(this.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, FrameEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public boolean isLossless() {
            return FrameEventArg.isLosslessImpl(this.getNativeResourceHandle());
        }

        public long getId() {
            return FrameEventArg.getIdImpl(this.getNativeResourceHandle());
        }

        public String getMessage() {
            return FrameEventArg.getMessageImpl(this.getNativeResourceHandle());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class KeyboardEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native long getKeyboardEventImpl(long var0);

        private static native long ctorImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        protected KeyboardEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public void setValue(KeyboardEventArg keyboardEventArg) {
            KeyboardEventArg.setValueImpl(this.getNativeResourceHandle(), keyboardEventArg.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, KeyboardEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public SoKeyboardEvent getKeyboardEvent() {
            return ObjectManager.getManagedObjectFor(SoKeyboardEvent.class, KeyboardEventArg.getKeyboardEventImpl(this.getNativeResourceHandle()));
        }

        public KeyboardEventArg(SoRemoteVizClient soRemoteVizClient, SoKeyboardEvent soKeyboardEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, KeyboardEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soKeyboardEvent != null ? soKeyboardEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class MessageEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native String getMessageImpl(long var0);

        private static native long ctorImpl(long var0, String var2);

        private static native long getSourceImpl(long var0);

        protected MessageEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public void setValue(MessageEventArg messageEventArg) {
            MessageEventArg.setValueImpl(this.getNativeResourceHandle(), messageEventArg.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, MessageEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public String getMessage() {
            return MessageEventArg.getMessageImpl(this.getNativeResourceHandle());
        }

        public MessageEventArg(SoRemoteVizClient soRemoteVizClient, String string) {
            this(Inventor.ConstructorCommand.CreateInstance, MessageEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, string));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class MouseButtonEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native long getMouseButtonEventImpl(long var0);

        private static native long ctorImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        protected MouseButtonEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public void setValue(MouseButtonEventArg mouseButtonEventArg) {
            MouseButtonEventArg.setValueImpl(this.getNativeResourceHandle(), mouseButtonEventArg.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, MouseButtonEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public SoMouseButtonEvent getMouseButtonEvent() {
            return ObjectManager.getManagedObjectFor(SoMouseButtonEvent.class, MouseButtonEventArg.getMouseButtonEventImpl(this.getNativeResourceHandle()));
        }

        public MouseButtonEventArg(SoRemoteVizClient soRemoteVizClient, SoMouseButtonEvent soMouseButtonEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, MouseButtonEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soMouseButtonEvent != null ? soMouseButtonEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class MouseLocationEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native long getMouseLocationEventImpl(long var0);

        private static native long ctorImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        protected MouseLocationEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public void setValue(MouseLocationEventArg mouseLocationEventArg) {
            MouseLocationEventArg.setValueImpl(this.getNativeResourceHandle(), mouseLocationEventArg.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, MouseLocationEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public SoLocation2Event getMouseLocationEvent() {
            return ObjectManager.getManagedObjectFor(SoLocation2Event.class, MouseLocationEventArg.getMouseLocationEventImpl(this.getNativeResourceHandle()));
        }

        public MouseLocationEventArg(SoRemoteVizClient soRemoteVizClient, SoLocation2Event soLocation2Event) {
            this(Inventor.ConstructorCommand.CreateInstance, MouseLocationEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soLocation2Event != null ? soLocation2Event.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class MouseWheelEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native long getMouseWheelEventImpl(long var0);

        private static native long ctorImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        protected MouseWheelEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public void setValue(MouseWheelEventArg mouseWheelEventArg) {
            MouseWheelEventArg.setValueImpl(this.getNativeResourceHandle(), mouseWheelEventArg.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, MouseWheelEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public SoMouseWheelEvent getMouseWheelEvent() {
            return ObjectManager.getManagedObjectFor(SoMouseWheelEvent.class, MouseWheelEventArg.getMouseWheelEventImpl(this.getNativeResourceHandle()));
        }

        public MouseWheelEventArg(SoRemoteVizClient soRemoteVizClient, SoMouseWheelEvent soMouseWheelEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, MouseWheelEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soMouseWheelEvent != null ? soMouseWheelEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class RenderAreaSizeEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native void getSizeImpl(long var0, short[] var2);

        private static native long ctorImpl(long var0, short[] var2);

        private static native long getSourceImpl(long var0);

        protected RenderAreaSizeEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public void setValue(RenderAreaSizeEventArg renderAreaSizeEventArg) {
            RenderAreaSizeEventArg.setValueImpl(this.getNativeResourceHandle(), renderAreaSizeEventArg.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, RenderAreaSizeEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public SbVec2s getSize() {
            SbVec2s sbVec2s = new SbVec2s();
            RenderAreaSizeEventArg.getSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
            return sbVec2s;
        }

        public RenderAreaSizeEventArg(SoRemoteVizClient soRemoteVizClient, SbVec2s sbVec2s) {
            this(Inventor.ConstructorCommand.CreateInstance, RenderAreaSizeEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec2s != null ? sbVec2s.array : null));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static class ServiceMessageEventArg
    extends Inventor
    implements SbEventArg {
        @Deprecated
        public static final int CONNECTED = States.access$000();
        @Deprecated
        public static final int DISCONNECTED = States.access$100();
        @Deprecated
        public static final int START_NETWORK_CALIBRATION = States.access$200();
        @Deprecated
        public static final int FINISH_NETWORK_CALIBRATION = States.access$300();
        @Deprecated
        public static final int START_BANDWIDTH_CALIBRATION = States.access$400();
        @Deprecated
        public static final int FINISH_BANDWIDTH_CALIBRATION = States.access$500();
        @Deprecated
        public static final int START_LATENCY_CALIBRATION = States.access$600();
        @Deprecated
        public static final int FINISH_LATENCY_CALIBRATION = States.access$700();

        private static native void setValueImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        private static native String getDetailsImpl(long var0);

        private static native void getRenderAreaSizeImpl(long var0, short[] var2);

        private static native int getStateImpl(long var0);

        private static native long ctorImpl(long var0, int var2, short[] var3, String var4);

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected ServiceMessageEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, ServiceMessageEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(ServiceMessageEventArg serviceMessageEventArg) {
            ServiceMessageEventArg.setValueImpl(this.getNativeResourceHandle(), serviceMessageEventArg.getNativeResourceHandle());
        }

        public SbVec2s getRenderAreaSize() {
            SbVec2s sbVec2s = new SbVec2s();
            ServiceMessageEventArg.getRenderAreaSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
            return sbVec2s;
        }

        public States getState() {
            return IntegerValuedEnumHelper.fromIntValue(States.class, ServiceMessageEventArg.getStateImpl(this.getNativeResourceHandle()));
        }

        public String getDetails() {
            return ServiceMessageEventArg.getDetailsImpl(this.getNativeResourceHandle());
        }

        public ServiceMessageEventArg(SoRemoteVizClient soRemoteVizClient, States states, SbVec2s sbVec2s, String string) {
            this(Inventor.ConstructorCommand.CreateInstance, ServiceMessageEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, states.getValue(), sbVec2s != null ? sbVec2s.array : null, string));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }

        public static enum States implements IntegerValuedEnum
        {
            CONNECTED(States.getCONNECTED()),
            DISCONNECTED(States.getDISCONNECTED()),
            START_NETWORK_CALIBRATION(States.getSTARTNETWORKCALIBRATION()),
            FINISH_NETWORK_CALIBRATION(States.getFINISHNETWORKCALIBRATION()),
            START_BANDWIDTH_CALIBRATION(States.getSTARTBANDWIDTHCALIBRATION()),
            FINISH_BANDWIDTH_CALIBRATION(States.getFINISHBANDWIDTHCALIBRATION()),
            START_LATENCY_CALIBRATION(States.getSTARTLATENCYCALIBRATION()),
            FINISH_LATENCY_CALIBRATION(States.getFINISHLATENCYCALIBRATION());

            private int value;

            private static native int getSTARTLATENCYCALIBRATION();

            private static native int getFINISHBANDWIDTHCALIBRATION();

            private States(int n2) {
                this.value = n2;
            }

            private static native int getFINISHLATENCYCALIBRATION();

            private static native int getSTARTBANDWIDTHCALIBRATION();

            private static native int getDISCONNECTED();

            private static native int getCONNECTED();

            private static native int getFINISHNETWORKCALIBRATION();

            private static native int getSTARTNETWORKCALIBRATION();

            @Deprecated
            public static States fromValue(int n) {
                return States.valueOf(n);
            }

            public static States valueOf(int n) {
                return IntegerValuedEnumHelper.fromIntValue(States.class, n);
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static /* synthetic */ int access$000() {
                return States.getCONNECTED();
            }

            static /* synthetic */ int access$100() {
                return States.getDISCONNECTED();
            }

            static /* synthetic */ int access$200() {
                return States.getSTARTNETWORKCALIBRATION();
            }

            static /* synthetic */ int access$300() {
                return States.getFINISHNETWORKCALIBRATION();
            }

            static /* synthetic */ int access$400() {
                return States.getSTARTBANDWIDTHCALIBRATION();
            }

            static /* synthetic */ int access$500() {
                return States.getFINISHBANDWIDTHCALIBRATION();
            }

            static /* synthetic */ int access$600() {
                return States.getSTARTLATENCYCALIBRATION();
            }

            static /* synthetic */ int access$700() {
                return States.getFINISHLATENCYCALIBRATION();
            }
        }
    }

    public static class TouchEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native long getTouchEventImpl(long var0);

        private static native long ctorImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        protected TouchEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public void setValue(TouchEventArg touchEventArg) {
            TouchEventArg.setValueImpl(this.getNativeResourceHandle(), touchEventArg.getNativeResourceHandle());
        }

        @Override
        public SoRemoteVizClient getSource() {
            return ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, TouchEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public SoTouchEvent getTouchEvent() {
            return ObjectManager.getManagedObjectFor(SoTouchEvent.class, TouchEventArg.getTouchEventImpl(this.getNativeResourceHandle()));
        }

        public TouchEventArg(SoRemoteVizClient soRemoteVizClient, SoTouchEvent soTouchEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, TouchEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soTouchEvent != null ? soTouchEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                ObjectManager.globalLock.lock();
                try {
                    NativeResourceHandle.deleteNativeHandleImpl(l);
                }
                finally {
                    ObjectManager.globalLock.unlock();
                }
            }
        }
    }

    public static enum SecurityProtocols implements IntegerValuedEnum
    {
        SSLv2(SecurityProtocols.getSSLv2()),
        SSLv3(SecurityProtocols.getSSLv3()),
        TLSv1(SecurityProtocols.getTLSv1()),
        TLSv1_1(SecurityProtocols.getTLSv11()),
        TLSv1_2(SecurityProtocols.getTLSv12());

        private int value;

        private static native int getTLSv11();

        private static native int getTLSv12();

        private SecurityProtocols(int n2) {
            this.value = n2;
        }

        private static native int getSSLv2();

        private static native int getSSLv3();

        private static native int getTLSv1();

        @Deprecated
        public static SecurityProtocols fromValue(int n) {
            return SecurityProtocols.valueOf(n);
        }

        public static SecurityProtocols valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$3800() {
            return SecurityProtocols.getSSLv2();
        }

        static /* synthetic */ int access$3900() {
            return SecurityProtocols.getSSLv3();
        }

        static /* synthetic */ int access$4000() {
            return SecurityProtocols.getTLSv1();
        }

        static /* synthetic */ int access$4100() {
            return SecurityProtocols.getTLSv11();
        }

        static /* synthetic */ int access$4200() {
            return SecurityProtocols.getTLSv12();
        }
    }

    public static enum StreamingModes implements IntegerValuedEnum
    {
        UNKNOWN(StreamingModes.getUNKNOWN()),
        IMAGE(StreamingModes.getIMAGE()),
        VIDEO(StreamingModes.getVIDEO());

        private int value;

        private static native int getVIDEO();

        private StreamingModes(int n2) {
            this.value = n2;
        }

        private static native int getUNKNOWN();

        private static native int getIMAGE();

        @Deprecated
        public static StreamingModes fromValue(int n) {
            return StreamingModes.valueOf(n);
        }

        public static StreamingModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(StreamingModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$3500() {
            return StreamingModes.getUNKNOWN();
        }

        static /* synthetic */ int access$3600() {
            return StreamingModes.getIMAGE();
        }

        static /* synthetic */ int access$3700() {
            return StreamingModes.getVIDEO();
        }
    }

    public static enum VideoDecoderType implements IntegerValuedEnum
    {
        NONE(VideoDecoderType.getNONE()),
        OPENH264(VideoDecoderType.getOPENH264()),
        INTEL_QUICKSYNC(VideoDecoderType.getINTELQUICKSYNC()),
        NVDECODE(VideoDecoderType.getNVDECODE());

        private int value;

        private static native int getNVDECODE();

        private VideoDecoderType(int n2) {
            this.value = n2;
        }

        private static native int getINTELQUICKSYNC();

        private static native int getNONE();

        private static native int getOPENH264();

        @Deprecated
        public static VideoDecoderType fromValue(int n) {
            return VideoDecoderType.valueOf(n);
        }

        public static VideoDecoderType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(VideoDecoderType.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$3100() {
            return VideoDecoderType.getNONE();
        }

        static /* synthetic */ int access$3200() {
            return VideoDecoderType.getOPENH264();
        }

        static /* synthetic */ int access$3300() {
            return VideoDecoderType.getINTELQUICKSYNC();
        }

        static /* synthetic */ int access$3400() {
            return VideoDecoderType.getNVDECODE();
        }
    }

    public static enum DisplayModes implements IntegerValuedEnum
    {
        STRETCH(DisplayModes.getSTRETCH()),
        CROP(DisplayModes.getCROP()),
        FIT(DisplayModes.getFIT());

        private int value;

        private static native int getFIT();

        private DisplayModes(int n2) {
            this.value = n2;
        }

        private static native int getSTRETCH();

        private static native int getCROP();

        @Deprecated
        public static DisplayModes fromValue(int n) {
            return DisplayModes.valueOf(n);
        }

        public static DisplayModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DisplayModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$2800() {
            return DisplayModes.getSTRETCH();
        }

        static /* synthetic */ int access$2900() {
            return DisplayModes.getCROP();
        }

        static /* synthetic */ int access$3000() {
            return DisplayModes.getFIT();
        }
    }
}

