/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.ClientSettings;
import com.openinventor.remoteviz.rendering.Connection;

public class Client
extends Inventor {
    private static native boolean isVideoStreamingSupportedImpl(long var0);

    private static native int getNumConnectionsImpl(long var0);

    private static native boolean sendMessageImpl(long var0, String var2, long[] var3, int var4);

    private static native String getEnvironmentImpl(long var0);

    private static native boolean isImageStreamingSupportedImpl(long var0);

    private static native String getApplicationNameImpl(long var0);

    private static native long getConnectionImpl1(long var0, int var2);

    private static native String getIdImpl(long var0);

    private static native void disconnectImpl(long var0);

    private static native long getConnectionImpl(long var0, String var2);

    private static native long getSettingsImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected Client(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean sendMessage(String string) {
        return this.sendMessage(string, null);
    }

    public Connection getConnection(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Connection connection = ObjectManager.getManagedObjectFor(Connection.class, Client.getConnectionImpl(this.getNativeResourceHandle(), string));
            return connection;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ClientSettings getSettings() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ClientSettings clientSettings = ObjectManager.getManagedObjectFor(ClientSettings.class, Client.getSettingsImpl(this.getNativeResourceHandle()));
            return clientSettings;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isImageStreamingSupported() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = Client.isImageStreamingSupportedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getId() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = Client.getIdImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getApplicationName() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = Client.getApplicationNameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isVideoStreamingSupported() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = Client.isVideoStreamingSupportedImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getEnvironment() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = Client.getEnvironmentImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(String string, Connection[] connectionArray) {
        boolean bl;
        long[] lArray = null;
        if (connectionArray != null) {
            lArray = new long[connectionArray.length];
            for (bl = false; bl < connectionArray.length; bl += 1) {
                lArray[bl] = connectionArray[bl] != null ? connectionArray[bl].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = Client.sendMessageImpl(this.getNativeResourceHandle(), string, lArray, null != connectionArray ? connectionArray.length : 0);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Connection getConnection(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Connection connection = ObjectManager.getManagedObjectFor(Connection.class, Client.getConnectionImpl1(this.getNativeResourceHandle(), n));
            return connection;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void disconnect() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Client.disconnectImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumConnections() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Client.getNumConnectionsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

