/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.Client;
import com.openinventor.remoteviz.rendering.ConnectionParameters;
import com.openinventor.remoteviz.rendering.ConnectionSettings;
import com.openinventor.remoteviz.rendering.EncodedFrame;
import com.openinventor.remoteviz.rendering.RenderArea;

public class Connection
extends Inventor {
    private static native int getRequestedWidthImpl(long var0);

    private static native void closeImpl(long var0);

    private static native long getRenderAreaImpl(long var0);

    private static native long getLastEncodedFrameImpl(long var0);

    private static native long getClientImpl(long var0);

    private static native int getContainerHeightImpl(long var0);

    private static native int getRequestedHeightImpl(long var0);

    private static native boolean sendMessageImpl(long var0, String var2);

    private static native String getIdImpl(long var0);

    private static native int getContainerWidthImpl(long var0);

    private static native long getSettingsImpl(long var0);

    private static native long getParametersImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected Connection(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public RenderArea getRenderArea() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea renderArea = ObjectManager.getManagedObjectFor(RenderArea.class, Connection.getRenderAreaImpl(this.getNativeResourceHandle()));
            return renderArea;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getRequestedWidth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Connection.getRequestedWidthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ConnectionParameters getParameters() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ConnectionParameters connectionParameters = ObjectManager.getManagedObjectFor(ConnectionParameters.class, Connection.getParametersImpl(this.getNativeResourceHandle()));
            return connectionParameters;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ConnectionSettings getSettings() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ConnectionSettings connectionSettings = ObjectManager.getManagedObjectFor(ConnectionSettings.class, Connection.getSettingsImpl(this.getNativeResourceHandle()));
            return connectionSettings;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getId() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = Connection.getIdImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public EncodedFrame getLastEncodedFrame() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            EncodedFrame encodedFrame = ObjectManager.getManagedObjectFor(EncodedFrame.class, Connection.getLastEncodedFrameImpl(this.getNativeResourceHandle()));
            return encodedFrame;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean sendMessage(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = Connection.sendMessageImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Client getClient() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Client client = ObjectManager.getManagedObjectFor(Client.class, Connection.getClientImpl(this.getNativeResourceHandle()));
            return client;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getContainerHeight() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Connection.getContainerHeightImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getRequestedHeight() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Connection.getRequestedHeightImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void close() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Connection.closeImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getContainerWidth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Connection.getContainerWidthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

