/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class ConnectionParameters
extends Inventor {
    private static native String getValueImpl(long var0, int var2);

    private static native String getKeyImpl(long var0, int var2);

    private static native String getValueImpl1(long var0, String var2);

    private static native int getIndexImpl(long var0, String var2);

    private static native int getNumParametersImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected ConnectionParameters(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public String getKey(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = ConnectionParameters.getKeyImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumParameters() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = ConnectionParameters.getNumParametersImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getValue(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string2 = ConnectionParameters.getValueImpl1(this.getNativeResourceHandle(), string);
            return string2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getIndex(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = ConnectionParameters.getIndexImpl(this.getNativeResourceHandle(), string);
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getValue(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = ConnectionParameters.getValueImpl(this.getNativeResourceHandle(), n);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

