/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.remoteviz.rendering.FrameEncoders;
import com.openinventor.remoteviz.rendering.IFrameEncodingPolicy;

public class ConnectionSettings
extends Inventor {
    private IFrameEncodingPolicy m_policy_setFrameEncodingPolicy;

    private static native long getFrameEncodingPolicyImpl(long var0);

    private static native void setKeepAliveTimeOutImpl(long var0, int var2);

    private static native int getKeepAliveTimeOutImpl(long var0);

    private static native boolean isSupportedEncodersImpl(long var0, long var2);

    private static native void setFrameEncodingPolicyImpl(long var0, long var2);

    private static native void setMaxFPSImpl(long var0, int var2);

    private static native long getFrameEncodersImpl(long var0);

    private static native int getMaxFPSImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected ConnectionSettings(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setKeepAliveTimeOut(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ConnectionSettings.setKeepAliveTimeOutImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public int getMaxFPS() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = ConnectionSettings.getMaxFPSImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public void setMaxFPS(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ConnectionSettings.setMaxFPSImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getKeepAliveTimeOut() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = ConnectionSettings.getKeepAliveTimeOutImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setFrameEncodingPolicy(IFrameEncodingPolicy iFrameEncodingPolicy) {
        this.m_policy_setFrameEncodingPolicy = iFrameEncodingPolicy;
        this.acquireLock(ObjectManager.globalLock);
        try {
            ConnectionSettings.setFrameEncodingPolicyImpl(this.getNativeResourceHandle(), iFrameEncodingPolicy != null ? iFrameEncodingPolicy.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSupportedEncoders(FrameEncoders frameEncoders) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = ConnectionSettings.isSupportedEncodersImpl(this.getNativeResourceHandle(), frameEncoders != null ? frameEncoders.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public IFrameEncodingPolicy getFrameEncodingPolicy() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            IFrameEncodingPolicy iFrameEncodingPolicy = ObjectManager.getManagedObjectFor(IFrameEncodingPolicy.class, ConnectionSettings.getFrameEncodingPolicyImpl(this.getNativeResourceHandle()));
            return iFrameEncodingPolicy;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FrameEncoders getFrameEncoders() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            FrameEncoders frameEncoders = ObjectManager.createManagedObject(FrameEncoders.class, (Long)ConnectionSettings.getFrameEncodersImpl(this.getNativeResourceHandle()), Inventor.ConstructorCommand.CreateInstance);
            return frameEncoders;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

