/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;

public class EncodedFrame
extends Inventor {
    @Deprecated
    public static final int JPEG = EncodingFormats.access$000();
    @Deprecated
    public static final int PNG = EncodingFormats.access$100();
    @Deprecated
    public static final int H264 = EncodingFormats.access$200();

    private static native int getEncodingFormatImpl(long var0);

    private static native boolean isLosslessImpl(long var0);

    private static native boolean isInteractiveImpl(long var0);

    private static native long getIdImpl(long var0);

    private static native long getBufferSizeImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected EncodedFrame(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public long getBufferSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = EncodedFrame.getBufferSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isLossless() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = EncodedFrame.isLosslessImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isInteractive() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = EncodedFrame.isInteractiveImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long getId() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = EncodedFrame.getIdImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public EncodingFormats getEncodingFormat() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            EncodingFormats encodingFormats = IntegerValuedEnumHelper.fromIntValue(EncodingFormats.class, EncodedFrame.getEncodingFormatImpl(this.getNativeResourceHandle()));
            return encodingFormats;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum EncodingFormats implements IntegerValuedEnum
    {
        JPEG(EncodingFormats.getJPEG()),
        PNG(EncodingFormats.getPNG()),
        H264(EncodingFormats.getH264());

        private int value;

        private static native int getH264();

        private EncodingFormats(int n2) {
            this.value = n2;
        }

        private static native int getJPEG();

        private static native int getPNG();

        @Deprecated
        public static EncodingFormats fromValue(int n) {
            return EncodingFormats.valueOf(n);
        }

        public static EncodingFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(EncodingFormats.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return EncodingFormats.getJPEG();
        }

        static /* synthetic */ int access$100() {
            return EncodingFormats.getPNG();
        }

        static /* synthetic */ int access$200() {
            return EncodingFormats.getH264();
        }
    }
}

