/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;

public class FrameEncoders
extends Inventor {
    @Deprecated
    public static final int NONE = Encoders.access$000();
    @Deprecated
    public static final int JPEG = Encoders.access$100();
    @Deprecated
    public static final int PNG = Encoders.access$200();
    @Deprecated
    public static final int H264_NVENC = Encoders.access$300();
    @Deprecated
    public static final int H264_OPENH264 = Encoders.access$400();
    @Deprecated
    public static final int SUPPORTED = Status.access$500();
    @Deprecated
    public static final int UNSUPPORTED = Status.access$600();
    @Deprecated
    public static final int INCOMPATIBLE = Status.access$700();
    @Deprecated
    public static final int CLIENT_UNSUPPORTED = Status.access$800();

    private static native void setInteractiveEncoderImpl(long var0, int var2);

    private static native int getStillEncoderImpl(long var0);

    private static native int getInteractiveEncoderImpl(long var0);

    private static native void setStillEncoderImpl(long var0, int var2);

    private static native int getStillEncoderStatusImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = FrameEncoders.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native int getInteractiveEncoderStatusImpl(long var0);

    private static native long ctorImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected FrameEncoders(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public Status getStillEncoderStatus() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Status status = IntegerValuedEnumHelper.fromIntValue(Status.class, FrameEncoders.getStillEncoderStatusImpl(this.getNativeResourceHandle()));
            return status;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public FrameEncoders() {
        this(Inventor.ConstructorCommand.CreateInstance, FrameEncoders.ctorImplSync());
    }

    public void setStillEncoder(Encoders encoders) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            FrameEncoders.setStillEncoderImpl(this.getNativeResourceHandle(), encoders.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setInteractiveEncoder(Encoders encoders) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            FrameEncoders.setInteractiveEncoderImpl(this.getNativeResourceHandle(), encoders.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Encoders getStillEncoder() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Encoders encoders = IntegerValuedEnumHelper.fromIntValue(Encoders.class, FrameEncoders.getStillEncoderImpl(this.getNativeResourceHandle()));
            return encoders;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Encoders getInteractiveEncoder() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Encoders encoders = IntegerValuedEnumHelper.fromIntValue(Encoders.class, FrameEncoders.getInteractiveEncoderImpl(this.getNativeResourceHandle()));
            return encoders;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Status getInteractiveEncoderStatus() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Status status = IntegerValuedEnumHelper.fromIntValue(Status.class, FrameEncoders.getInteractiveEncoderStatusImpl(this.getNativeResourceHandle()));
            return status;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum Status implements IntegerValuedEnum
    {
        SUPPORTED(Status.getSUPPORTED()),
        UNSUPPORTED(Status.getUNSUPPORTED()),
        INCOMPATIBLE(Status.getINCOMPATIBLE()),
        CLIENT_UNSUPPORTED(Status.getCLIENTUNSUPPORTED());

        private int value;

        private static native int getCLIENTUNSUPPORTED();

        private Status(int n2) {
            this.value = n2;
        }

        private static native int getINCOMPATIBLE();

        private static native int getSUPPORTED();

        private static native int getUNSUPPORTED();

        @Deprecated
        public static Status fromValue(int n) {
            return Status.valueOf(n);
        }

        public static Status valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Status.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$500() {
            return Status.getSUPPORTED();
        }

        static /* synthetic */ int access$600() {
            return Status.getUNSUPPORTED();
        }

        static /* synthetic */ int access$700() {
            return Status.getINCOMPATIBLE();
        }

        static /* synthetic */ int access$800() {
            return Status.getCLIENTUNSUPPORTED();
        }
    }

    public static enum Encoders implements IntegerValuedEnum
    {
        NONE(Encoders.getNONE()),
        JPEG(Encoders.getJPEG()),
        PNG(Encoders.getPNG()),
        H264_NVENC(Encoders.getH264NVENC()),
        H264_OPENH264(Encoders.getH264OPENH264());

        private int value;

        private static native int getH264NVENC();

        private static native int getH264OPENH264();

        private Encoders(int n2) {
            this.value = n2;
        }

        private static native int getNONE();

        private static native int getJPEG();

        private static native int getPNG();

        @Deprecated
        public static Encoders fromValue(int n) {
            return Encoders.valueOf(n);
        }

        public static Encoders valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Encoders.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return Encoders.getNONE();
        }

        static /* synthetic */ int access$100() {
            return Encoders.getJPEG();
        }

        static /* synthetic */ int access$200() {
            return Encoders.getPNG();
        }

        static /* synthetic */ int access$300() {
            return Encoders.getH264NVENC();
        }

        static /* synthetic */ int access$400() {
            return Encoders.getH264OPENH264();
        }
    }
}

