/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class NetworkPerformance
extends Inventor {
    private static native void setMaxCalibrationDurationImpl(long var0, int var2);

    private static native int getBandwidthImpl(long var0);

    private static native int getLatencyImpl(long var0);

    private static native boolean isCalibrationEnabledImpl(long var0);

    private static native int getMaxCalibrationDurationImpl(long var0);

    private static native void enableCalibrationImpl(long var0, boolean var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected NetworkPerformance(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean isCalibrationEnabled() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = NetworkPerformance.isCalibrationEnabledImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void enableCalibration(boolean bl) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            NetworkPerformance.enableCalibrationImpl(this.getNativeResourceHandle(), bl);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setMaxCalibrationDuration(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            NetworkPerformance.setMaxCalibrationDurationImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getBandwidth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = NetworkPerformance.getBandwidthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getLatency() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = NetworkPerformance.getLatencyImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getMaxCalibrationDuration() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = NetworkPerformance.getMaxCalibrationDurationImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

