/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.touch.SoTouchManager;
import com.openinventor.remoteviz.rendering.Connection;
import com.openinventor.remoteviz.rendering.RenderAreaListener;

public class RenderArea
extends Inventor {
    private static native long getGLContextImpl(long var0);

    private static native void removeListenerImpl(long var0, long var2);

    private static native void removeAllListenersImpl(long var0);

    private static native int getNumListenersImpl(long var0);

    private static native long getTouchManagerImpl(long var0);

    private static native void closeConnectionsAndDisposeImpl(long var0);

    private static native void resizeImpl(long var0, int var2, int var3);

    private static native int getWidthImpl(long var0);

    private static native boolean sendMessageImpl(long var0, String var2, long[] var3, int var4);

    private static native void addListenerImpl(long var0, long var2);

    private static native long getSceneManagerImpl(long var0);

    private static native long getConnectionImpl(long var0, String var2);

    private static native int getHeightImpl(long var0);

    private static native String getIdImpl(long var0);

    private static native int getNumConnectionsImpl(long var0);

    private static native String getGpuImpl(long var0);

    private static native long getConnectionImpl1(long var0, int var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected RenderArea(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean sendMessage(String string) {
        return this.sendMessage(string, null);
    }

    public SoSceneManager getSceneManager() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoSceneManager soSceneManager = ObjectManager.getManagedObjectFor(SoSceneManager.class, RenderArea.getSceneManagerImpl(this.getNativeResourceHandle()));
            return soSceneManager;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getGpu() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = RenderArea.getGpuImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoTouchManager getTouchManager() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTouchManager soTouchManager = ObjectManager.getManagedObjectFor(SoTouchManager.class, RenderArea.getTouchManagerImpl(this.getNativeResourceHandle()));
            return soTouchManager;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumConnections() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = RenderArea.getNumConnectionsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Connection getConnection(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Connection connection = ObjectManager.getManagedObjectFor(Connection.class, RenderArea.getConnectionImpl(this.getNativeResourceHandle(), string));
            return connection;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getId() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = RenderArea.getIdImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Connection getConnection(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Connection connection = ObjectManager.getManagedObjectFor(Connection.class, RenderArea.getConnectionImpl1(this.getNativeResourceHandle(), n));
            return connection;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumListeners() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = RenderArea.getNumListenersImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getHeight() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = RenderArea.getHeightImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addListener(RenderAreaListener renderAreaListener) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea.addListenerImpl(this.getNativeResourceHandle(), renderAreaListener != null ? renderAreaListener.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void resize(int n, int n2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea.resizeImpl(this.getNativeResourceHandle(), n, n2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void closeConnectionsAndDispose() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea.closeConnectionsAndDisposeImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getWidth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = RenderArea.getWidthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeAllListeners() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea.removeAllListenersImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoGLContext getGLContext() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoGLContext soGLContext = ObjectManager.getManagedObjectFor(SoGLContext.class, RenderArea.getGLContextImpl(this.getNativeResourceHandle()));
            return soGLContext;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeListener(RenderAreaListener renderAreaListener) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea.removeListenerImpl(this.getNativeResourceHandle(), renderAreaListener != null ? renderAreaListener.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(String string, Connection[] connectionArray) {
        boolean bl;
        long[] lArray = null;
        if (connectionArray != null) {
            lArray = new long[connectionArray.length];
            for (bl = false; bl < connectionArray.length; bl += 1) {
                lArray[bl] = connectionArray[bl] != null ? connectionArray[bl].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = RenderArea.sendMessageImpl(this.getNativeResourceHandle(), string, lArray, null != connectionArray ? connectionArray.length : 0);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

