/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoDB;
import com.openinventor.remoteviz.rendering.Client;
import com.openinventor.remoteviz.rendering.RenderArea;
import com.openinventor.remoteviz.rendering.RenderAreaHardware;
import com.openinventor.remoteviz.rendering.ServiceListener;
import com.openinventor.remoteviz.rendering.ServiceSettings;

public class Service
extends Inventor {
    private ServiceSettings m_instanceSettings_open;

    private static native void setLicenseLanguage();

    private static native void createRenderAreaImpl(long var0, String var2, int var3, int var4, long var5);

    private static native void removeListenerImpl(long var0, long var2);

    private static native boolean isRunningImpl(long var0);

    private static native void removeAllListenersImpl(long var0);

    private static native long getRenderAreaImpl(long var0, String var2);

    private static native long getSettingsImpl(long var0);

    private static native int getNumRenderAreasImpl(long var0);

    private static native void addListenerImpl(long var0, long var2);

    private static native long getRenderAreaImpl1(long var0, int var2);

    private static native int getNumListenersImpl(long var0);

    private static native long instanceImpl();

    private static native int getNumClientsImpl(long var0);

    private static native void dispatchImpl(long var0);

    private static native long getClientImpl(long var0, String var2);

    private static native boolean closeImpl(long var0);

    private static native long getClientImpl1(long var0, int var2);

    private static native boolean openImpl(long var0, long var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected Service(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        String string = System.getProperty("os.name");
        if (string.startsWith("Mac")) {
            throw new UnsupportedOperationException("Unsupported platform.");
        }
        Service.setLicenseLanguage();
        this.initializeFields();
    }

    public boolean open(ServiceSettings serviceSettings) {
        SoDB.setSystemTimer(null);
        this.m_instanceSettings_open = serviceSettings;
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = Service.openImpl(this.getNativeResourceHandle(), serviceSettings != null ? serviceSettings.getNativeResourceHandle() : Inventor.ZeroHandle);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Client getClient(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Client client = ObjectManager.getManagedObjectFor(Client.class, Service.getClientImpl1(this.getNativeResourceHandle(), n));
            return client;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean close() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = Service.closeImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumClients() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Service.getNumClientsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ServiceSettings getSettings() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings serviceSettings = ObjectManager.getManagedObjectFor(ServiceSettings.class, Service.getSettingsImpl(this.getNativeResourceHandle()));
            return serviceSettings;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public static Service instance() {
        ObjectManager.globalLock.lock();
        try {
            Service service = ObjectManager.getManagedObjectFor(Service.class, Service.instanceImpl());
            return service;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    public void dispatch() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Service.dispatchImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public Client getClient(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Client client = ObjectManager.getManagedObjectFor(Client.class, Service.getClientImpl(this.getNativeResourceHandle(), string));
            return client;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public RenderArea getRenderArea(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea renderArea = ObjectManager.getManagedObjectFor(RenderArea.class, Service.getRenderAreaImpl1(this.getNativeResourceHandle(), n));
            return renderArea;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeListener(ServiceListener serviceListener) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Service.removeListenerImpl(this.getNativeResourceHandle(), serviceListener != null ? serviceListener.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumRenderAreas() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Service.getNumRenderAreasImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void addListener(ServiceListener serviceListener) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Service.addListenerImpl(this.getNativeResourceHandle(), serviceListener != null ? serviceListener.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public RenderArea getRenderArea(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RenderArea renderArea = ObjectManager.getManagedObjectFor(RenderArea.class, Service.getRenderAreaImpl(this.getNativeResourceHandle(), string));
            return renderArea;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumListeners() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = Service.getNumListenersImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isRunning() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = Service.isRunningImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void removeAllListeners() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Service.removeAllListenersImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRenderArea(String string, int n, int n2, RenderAreaHardware renderAreaHardware) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Service.createRenderAreaImpl(this.getNativeResourceHandle(), string, n, n2, renderAreaHardware != null ? renderAreaHardware.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

