/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.rendering;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import java.util.EnumSet;

public class ServiceSettings
extends Inventor
implements Cloneable {
    @Deprecated
    public static final int INVENTOR_SERVICE = RunModes.access$000();
    @Deprecated
    public static final int INVENTOR_APPLICATION = RunModes.access$100();
    @Deprecated
    public static final int INDEPENDENT_SERVICE = RunModes.access$200();
    @Deprecated
    public static final int VOLUMEVIZ = Extensions.access$300();
    @Deprecated
    public static final int VOLUMEVIZLDM = Extensions.access$400();
    @Deprecated
    public static final int MESHVIZ = Extensions.access$500();
    @Deprecated
    public static final int MESHVIZXLM = Extensions.access$600();
    @Deprecated
    public static final int IMAGEVIZ = Extensions.access$700();
    @Deprecated
    public static final int HARDCOPY = Extensions.access$800();
    @Deprecated
    public static final int CATIA5READER = Extensions.access$900();
    @Deprecated
    public static final int CATIA6READER = Extensions.access$1000();
    @Deprecated
    public static final int DWGREADER = Extensions.access$1100();
    @Deprecated
    public static final int IGESREADER = Extensions.access$1200();
    @Deprecated
    public static final int JTREADER = Extensions.access$1300();
    @Deprecated
    public static final int PROEREADER = Extensions.access$1400();
    @Deprecated
    public static final int SOLIDEDGEREADER = Extensions.access$1500();
    @Deprecated
    public static final int STEPREADER = Extensions.access$1600();
    @Deprecated
    public static final int SOLIDWORKSREADER = Extensions.access$1700();
    @Deprecated
    public static final int UGREADER = Extensions.access$1800();
    @Deprecated
    public static final int VDAREADER = Extensions.access$1900();
    @Deprecated
    public static final int XMTREADER = Extensions.access$2000();
    @Deprecated
    public static final int SSLv2 = SecurityProtocols.access$2100();
    @Deprecated
    public static final int SSLv3 = SecurityProtocols.access$2200();
    @Deprecated
    public static final int TLSv1 = SecurityProtocols.access$2300();
    @Deprecated
    public static final int TLSv1_1 = SecurityProtocols.access$2400();
    @Deprecated
    public static final int TLSv1_2 = SecurityProtocols.access$2500();

    private void checkExtensions(EnumSet<Extensions> enumSet) {
        if (enumSet.contains(Extensions.IMAGEVIZ)) {
            Inventor.checkIVizLP();
        }
        if (enumSet.contains(Extensions.MESHVIZ)) {
            Inventor.checkMVizLP();
        }
        if (enumSet.contains(Extensions.MESHVIZXLM)) {
            Inventor.checkMVizXLMLP();
        }
        if (enumSet.contains(Extensions.VOLUMEVIZ)) {
            Inventor.checkVVizLP();
        }
        if (enumSet.contains(Extensions.VOLUMEVIZLDM)) {
            Inventor.checkVldmLP();
        }
    }

    private static native void enableSecureConnectionImpl2(long var0, String var2, String var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void enableSecureConnection(String string, String string2, SecurityProtocols securityProtocols) {
        ObjectManager.globalLock.lock();
        try {
            ServiceSettings.enableSecureConnectionImpl2(this.getNativeResourceHandle(), string, string2, securityProtocols.getValue());
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void enableSecureConnection(String string, String string2, int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings.enableSecureConnectionImpl2(this.getNativeResourceHandle(), string, string2, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static native int getUsedExtensionsImpl(long var0);

    @Deprecated
    public Extensions getUsedExtensions() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            Extensions extensions = IntegerValuedEnumHelper.fromIntValue(Extensions.class, ServiceSettings.getUsedExtensionsImpl(this.getNativeResourceHandle()));
            return extensions;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static native void setUsedExtensionsImpl(long var0, int var2);

    @Deprecated
    public void setUsedExtensions(Extensions extensions) {
        this.checkExtensions(EnumSet.of(extensions));
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings.setUsedExtensionsImpl(this.getNativeResourceHandle(), extensions.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static native int getEnabledSecurityProtocolsImpl(long var0);

    private static native int getRunModeImpl(long var0);

    private static native long ctorImpl();

    private static native void setRunModeImpl(long var0, int var2);

    private static native boolean isSecureConnectionImpl(long var0);

    private static native void setOivUsedExtensionsImpl(long var0, int var2);

    private static native int getOivUsedExtensionsImpl(long var0);

    private static native String getHostnameImpl(long var0);

    private static native void enableSecureConnectionImpl(long var0, String var2, String var3, int var4);

    private static native void setIPImpl(long var0, String var2);

    private static native String getPrivateKeyFileImpl(long var0);

    private static long ctorImpl1Sync(ServiceSettings serviceSettings) {
        ObjectManager.globalLock.lock();
        try {
            long l = ServiceSettings.ctorImpl1(serviceSettings != null ? serviceSettings.getNativeResourceHandle() : Inventor.ZeroHandle);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = ServiceSettings.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native String getIPImpl(long var0);

    private static native long ctorImpl1(long var0);

    private static native short getPortImpl(long var0);

    private static native String getPublicCertificateFileImpl(long var0);

    private static native void setPortImpl(long var0, short var2);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected ServiceSettings(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void enableSecureConnection(String string, String string2) {
        this.enableSecureConnection(string, string2, EnumSet.of(SecurityProtocols.TLSv1, SecurityProtocols.TLSv1_1, SecurityProtocols.TLSv1_2));
    }

    public Object clone() {
        ServiceSettings serviceSettings = new ServiceSettings(this);
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings serviceSettings2 = serviceSettings;
            return serviceSettings2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getPublicCertificateFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = ServiceSettings.getPublicCertificateFileImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSecureConnection(String string, String string2, EnumSet<SecurityProtocols> enumSet) {
        int n = IntegerValuedEnumHelper.valueOf(enumSet);
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings.enableSecureConnectionImpl(this.getNativeResourceHandle(), string, string2, n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setPort(short s) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings.setPortImpl(this.getNativeResourceHandle(), s);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setIP(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings.setIPImpl(this.getNativeResourceHandle(), string);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getIP() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = ServiceSettings.getIPImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getPrivateKeyFile() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = ServiceSettings.getPrivateKeyFileImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public String getHostname() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = ServiceSettings.getHostnameImpl(this.getNativeResourceHandle());
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SecurityProtocols getEnabledSecurityProtocols() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SecurityProtocols securityProtocols = IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, ServiceSettings.getEnabledSecurityProtocolsImpl(this.getNativeResourceHandle()));
            return securityProtocols;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isSecureConnection() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = ServiceSettings.isSecureConnectionImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public EnumSet<Extensions> getOivUsedExtensions() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            EnumSet<Extensions> enumSet = IntegerValuedEnumHelper.enumSetOf(Extensions.class, ServiceSettings.getOivUsedExtensionsImpl(this.getNativeResourceHandle()));
            return enumSet;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setOivUsedExtensions(EnumSet<Extensions> enumSet) {
        this.checkExtensions(enumSet);
        int n = IntegerValuedEnumHelper.valueOf(enumSet);
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings.setOivUsedExtensionsImpl(this.getNativeResourceHandle(), n);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ServiceSettings(ServiceSettings serviceSettings) {
        this(Inventor.ConstructorCommand.CreateInstance, ServiceSettings.ctorImpl1Sync(serviceSettings));
    }

    public short getPort() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            short s = ServiceSettings.getPortImpl(this.getNativeResourceHandle());
            return s;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public void setRunMode(RunModes runModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            ServiceSettings.setRunModeImpl(this.getNativeResourceHandle(), runModes.getValue());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public RunModes getRunMode() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            RunModes runModes = IntegerValuedEnumHelper.fromIntValue(RunModes.class, ServiceSettings.getRunModeImpl(this.getNativeResourceHandle()));
            return runModes;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public ServiceSettings() {
        this(Inventor.ConstructorCommand.CreateInstance, ServiceSettings.ctorImplSync());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum SecurityProtocols implements IntegerValuedEnum
    {
        SSLv2(SecurityProtocols.getSSLv2()),
        SSLv3(SecurityProtocols.getSSLv3()),
        TLSv1(SecurityProtocols.getTLSv1()),
        TLSv1_1(SecurityProtocols.getTLSv11()),
        TLSv1_2(SecurityProtocols.getTLSv12());

        private int value;

        private static native int getTLSv11();

        private static native int getTLSv12();

        private SecurityProtocols(int n2) {
            this.value = n2;
        }

        private static native int getSSLv2();

        private static native int getSSLv3();

        private static native int getTLSv1();

        @Deprecated
        public static SecurityProtocols fromValue(int n) {
            return SecurityProtocols.valueOf(n);
        }

        public static SecurityProtocols valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$2100() {
            return SecurityProtocols.getSSLv2();
        }

        static /* synthetic */ int access$2200() {
            return SecurityProtocols.getSSLv3();
        }

        static /* synthetic */ int access$2300() {
            return SecurityProtocols.getTLSv1();
        }

        static /* synthetic */ int access$2400() {
            return SecurityProtocols.getTLSv11();
        }

        static /* synthetic */ int access$2500() {
            return SecurityProtocols.getTLSv12();
        }
    }

    public static enum Extensions implements IntegerValuedEnum
    {
        VOLUMEVIZ(Extensions.getVOLUMEVIZ()),
        VOLUMEVIZLDM(Extensions.getVOLUMEVIZLDM()),
        MESHVIZ(Extensions.getMESHVIZ()),
        MESHVIZXLM(Extensions.getMESHVIZXLM()),
        IMAGEVIZ(Extensions.getIMAGEVIZ()),
        HARDCOPY(Extensions.getHARDCOPY()),
        CATIA5READER(Extensions.getCATIA5READER()),
        CATIA6READER(Extensions.getCATIA6READER()),
        DWGREADER(Extensions.getDWGREADER()),
        IGESREADER(Extensions.getIGESREADER()),
        JTREADER(Extensions.getJTREADER()),
        PROEREADER(Extensions.getPROEREADER()),
        SOLIDEDGEREADER(Extensions.getSOLIDEDGEREADER()),
        STEPREADER(Extensions.getSTEPREADER()),
        SOLIDWORKSREADER(Extensions.getSOLIDWORKSREADER()),
        UGREADER(Extensions.getUGREADER()),
        VDAREADER(Extensions.getVDAREADER()),
        XMTREADER(Extensions.getXMTREADER());

        private int value;

        private static native int getSOLIDEDGEREADER();

        private static native int getSTEPREADER();

        private static native int getJTREADER();

        private static native int getPROEREADER();

        private static native int getSOLIDWORKSREADER();

        private static native int getXMTREADER();

        private Extensions(int n2) {
            this.value = n2;
        }

        private static native int getUGREADER();

        private static native int getVDAREADER();

        private static native int getIGESREADER();

        private static native int getMESHVIZ();

        private static native int getMESHVIZXLM();

        private static native int getVOLUMEVIZ();

        private static native int getVOLUMEVIZLDM();

        private static native int getIMAGEVIZ();

        private static native int getCATIA6READER();

        private static native int getDWGREADER();

        private static native int getHARDCOPY();

        private static native int getCATIA5READER();

        @Deprecated
        public static Extensions fromValue(int n) {
            return Extensions.valueOf(n);
        }

        public static Extensions valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Extensions.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$300() {
            return Extensions.getVOLUMEVIZ();
        }

        static /* synthetic */ int access$400() {
            return Extensions.getVOLUMEVIZLDM();
        }

        static /* synthetic */ int access$500() {
            return Extensions.getMESHVIZ();
        }

        static /* synthetic */ int access$600() {
            return Extensions.getMESHVIZXLM();
        }

        static /* synthetic */ int access$700() {
            return Extensions.getIMAGEVIZ();
        }

        static /* synthetic */ int access$800() {
            return Extensions.getHARDCOPY();
        }

        static /* synthetic */ int access$900() {
            return Extensions.getCATIA5READER();
        }

        static /* synthetic */ int access$1000() {
            return Extensions.getCATIA6READER();
        }

        static /* synthetic */ int access$1100() {
            return Extensions.getDWGREADER();
        }

        static /* synthetic */ int access$1200() {
            return Extensions.getIGESREADER();
        }

        static /* synthetic */ int access$1300() {
            return Extensions.getJTREADER();
        }

        static /* synthetic */ int access$1400() {
            return Extensions.getPROEREADER();
        }

        static /* synthetic */ int access$1500() {
            return Extensions.getSOLIDEDGEREADER();
        }

        static /* synthetic */ int access$1600() {
            return Extensions.getSTEPREADER();
        }

        static /* synthetic */ int access$1700() {
            return Extensions.getSOLIDWORKSREADER();
        }

        static /* synthetic */ int access$1800() {
            return Extensions.getUGREADER();
        }

        static /* synthetic */ int access$1900() {
            return Extensions.getVDAREADER();
        }

        static /* synthetic */ int access$2000() {
            return Extensions.getXMTREADER();
        }
    }

    public static enum RunModes implements IntegerValuedEnum
    {
        INVENTOR_SERVICE(RunModes.getINVENTORSERVICE()),
        INVENTOR_APPLICATION(RunModes.getINVENTORAPPLICATION()),
        INDEPENDENT_SERVICE(RunModes.getINDEPENDENTSERVICE());

        private int value;

        private static native int getINDEPENDENTSERVICE();

        private RunModes(int n2) {
            this.value = n2;
        }

        private static native int getINVENTORSERVICE();

        private static native int getINVENTORAPPLICATION();

        @Deprecated
        public static RunModes fromValue(int n) {
            return RunModes.valueOf(n);
        }

        public static RunModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(RunModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return RunModes.getINVENTORSERVICE();
        }

        static /* synthetic */ int access$100() {
            return RunModes.getINVENTORAPPLICATION();
        }

        static /* synthetic */ int access$200() {
            return RunModes.getINDEPENDENTSERVICE();
        }
    }
}

