/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.scaleviz.interaction;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoControllerReader
extends Inventor {
    private static native int buttonChangeImpl(long var0, int var2);

    private static native int getNumberOfValuatorsImpl(long var0);

    private static native int getNumberOfButtonsImpl(long var0);

    private static native float getValuatorImpl(long var0, int var2);

    private static native int getButtonImpl(long var0, int var2);

    private static long ctorImplSync(int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoControllerReader.ctorImpl(n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl(int var0);

    private static native boolean isLoadSuccessImpl(long var0);

    private static native boolean isInitSuccessImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoControllerReader(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean isInitSuccess() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoControllerReader.isInitSuccessImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getButton(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoControllerReader.getButtonImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoControllerReader(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoControllerReader.ctorImplSync(n));
    }

    public int buttonChange(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n2 = SoControllerReader.buttonChangeImpl(this.getNativeResourceHandle(), n);
            return n2;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getValuator(int n) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoControllerReader.getValuatorImpl(this.getNativeResourceHandle(), n);
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumberOfButtons() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoControllerReader.getNumberOfButtonsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getNumberOfValuators() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoControllerReader.getNumberOfValuatorsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isLoadSuccess() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoControllerReader.isLoadSuccessImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

