/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.scaleviz.interaction;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec3f;

public class SoTrackerReader
extends Inventor {
    private static native void setTransformMatrixImpl(long var0, int var2, float[] var3);

    private static native void getTransformMatrixImpl(long var0, int var2, float[] var3);

    private static native void getPositionImpl(long var0, int var2, float[] var3);

    private static native void getEulerAnglesImpl(long var0, int var2, float[] var3);

    private static native boolean isLoadSuccessImpl(long var0);

    private static native boolean isInitSuccessImpl(long var0);

    private static native void setUnitScaleFactorImpl(long var0, float var2);

    private static long ctorImplSync(int n) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoTrackerReader.ctorImpl(n);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl(int var0);

    private static native void getMatrixImpl1(long var0, int var2, float[] var3);

    private static native float getUnitScaleFactorImpl(long var0);

    private static native int getNumberOfSensorsImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoTrackerReader(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setUnitScaleFactor(float f) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTrackerReader.setUnitScaleFactorImpl(this.getNativeResourceHandle(), f);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f getPosition(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTrackerReader.getPositionImpl(this.getNativeResourceHandle(), n, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public float getUnitScaleFactor() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoTrackerReader.getUnitScaleFactorImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoTrackerReader(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoTrackerReader.ctorImplSync(n));
    }

    public int getNumberOfSensors() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoTrackerReader.getNumberOfSensorsImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isInitSuccess() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoTrackerReader.isInitSuccessImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbMatrix getMatrix(int n) {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTrackerReader.getMatrixImpl1(this.getNativeResourceHandle(), n, sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public void setTransformMatrix(int n, SbMatrix sbMatrix) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTrackerReader.setTransformMatrixImpl(this.getNativeResourceHandle(), n, sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean isLoadSuccess() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoTrackerReader.isLoadSuccessImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbMatrix getTransformMatrix(int n) {
        SbMatrix sbMatrix = new SbMatrix();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTrackerReader.getTransformMatrixImpl(this.getNativeResourceHandle(), n, sbMatrix.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbMatrix;
    }

    public SbVec3f getEulerAngles(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTrackerReader.getEulerAnglesImpl(this.getNativeResourceHandle(), n, sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

