/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.scaleviz.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;

public class SoMemoryBuffer
extends Inventor {
    private static native long getSizeImpl(long var0);

    private static native void setSizeImpl(long var0, long var2, long var4);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMemoryBuffer.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getNbElementImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoMemoryBuffer(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setSize(long l) {
        this.setSize(l, 1L);
    }

    public long getSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMemoryBuffer.getSizeImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(long l, long l2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMemoryBuffer.setSizeImpl(this.getNativeResourceHandle(), l, l2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public long getNbElement() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            long l = SoMemoryBuffer.getNbElementImpl(this.getNativeResourceHandle());
            return l;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMemoryBuffer() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMemoryBuffer.ctorImplSync());
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

