/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.scaleviz.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.scaleviz.misc.SoMemoryBuffer;

public class SoMemoryBufferCompression
extends Inventor {
    @Deprecated
    public static final int NONE = CompressionModes.access$000();
    @Deprecated
    public static final int ZLIB = CompressionModes.access$100();
    @Deprecated
    public static final int BZIP2 = CompressionModes.access$200();
    @Deprecated
    public static final int PBZIP2 = CompressionModes.access$300();
    private SoMemoryBuffer m_src_setSource;
    private SoMemoryBuffer m_dst_setDestination;

    private static native int compressImpl(long var0, int var2);

    private static native void setSourceImpl(long var0, long var2, long var4, long var6);

    private static native void setDestinationImpl(long var0, long var2, long var4);

    private static native int uncompressImpl(long var0, int var2);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoMemoryBufferCompression.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl();

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoMemoryBufferCompression(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setSource(SoMemoryBuffer soMemoryBuffer, long l) {
        this.setSource(soMemoryBuffer, l, 0L);
    }

    public void setSource(SoMemoryBuffer soMemoryBuffer) {
        this.setSource(soMemoryBuffer, 0L, 0L);
    }

    public void setDestination(SoMemoryBuffer soMemoryBuffer) {
        this.setDestination(soMemoryBuffer, 0L);
    }

    public int compress(CompressionModes compressionModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMemoryBufferCompression.compressImpl(this.getNativeResourceHandle(), compressionModes.getValue());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(SoMemoryBuffer soMemoryBuffer, long l, long l2) {
        this.m_src_setSource = soMemoryBuffer;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMemoryBufferCompression.setSourceImpl(this.getNativeResourceHandle(), soMemoryBuffer != null ? soMemoryBuffer.getNativeResourceHandle() : Inventor.ZeroHandle, l, l2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestination(SoMemoryBuffer soMemoryBuffer, long l) {
        this.m_dst_setDestination = soMemoryBuffer;
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoMemoryBufferCompression.setDestinationImpl(this.getNativeResourceHandle(), soMemoryBuffer != null ? soMemoryBuffer.getNativeResourceHandle() : Inventor.ZeroHandle, l);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoMemoryBufferCompression() {
        this(Inventor.ConstructorCommand.CreateInstance, SoMemoryBufferCompression.ctorImplSync());
    }

    public int uncompress(CompressionModes compressionModes) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoMemoryBufferCompression.uncompressImpl(this.getNativeResourceHandle(), compressionModes.getValue());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }

    public static enum CompressionModes implements IntegerValuedEnum
    {
        NONE(CompressionModes.getNONE()),
        ZLIB(CompressionModes.getZLIB()),
        BZIP2(CompressionModes.getBZIP2()),
        PBZIP2(CompressionModes.getPBZIP2());

        private int value;

        private static native int getPBZIP2();

        private CompressionModes(int n2) {
            this.value = n2;
        }

        private static native int getBZIP2();

        private static native int getNONE();

        private static native int getZLIB();

        @Deprecated
        public static CompressionModes fromValue(int n) {
            return CompressionModes.valueOf(n);
        }

        public static CompressionModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CompressionModes.class, n);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static /* synthetic */ int access$000() {
            return CompressionModes.getNONE();
        }

        static /* synthetic */ int access$100() {
            return CompressionModes.getZLIB();
        }

        static /* synthetic */ int access$200() {
            return CompressionModes.getBZIP2();
        }

        static /* synthetic */ int access$300() {
            return CompressionModes.getPBZIP2();
        }
    }
}

