/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.scaleviz.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFVec4f;
import com.openinventor.inventor.fields.SoSFFilePathString;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.fields.SoSFVec3f;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.scaleviz.interaction.SoControllerReader;
import com.openinventor.scaleviz.interaction.SoTrackerReader;

public class SoTracker
extends SoNode {
    public final SoSFVec3f defaultCameraPosition;
    public final SoSFVec3f defaultObjectPosition;
    public final SoSFFloat defaultObjectBoxMaxDim;
    public final SoSFFloat unitScaleFactor;
    public final SoSFString server;
    public final SoSFFloat interEyeDistance;
    public final SoSFInt32 wandTrackerId;
    public final SoSFInt32 headTrackerId;
    public final SoSFFilePathString wandFile;
    public final SoMFVec4f calibrate;

    private static native long getTrackerReaderImpl(long var0);

    private static native long ctorImpl();

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoTracker.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getControllerReaderImpl(long var0);

    protected SoTracker(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.defaultCameraPosition = ObjectManager.getManagedObjectFor(SoSFVec3f.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "defaultCameraPosition"));
        this.defaultObjectPosition = ObjectManager.getManagedObjectFor(SoSFVec3f.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "defaultObjectPosition"));
        this.defaultObjectBoxMaxDim = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "defaultObjectBoxMaxDim"));
        this.unitScaleFactor = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "unitScaleFactor"));
        this.server = ObjectManager.getManagedObjectFor(SoSFString.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "server"));
        this.interEyeDistance = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "interEyeDistance"));
        this.wandTrackerId = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "wandTrackerId"));
        this.headTrackerId = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "headTrackerId"));
        this.wandFile = ObjectManager.getManagedObjectFor(SoSFFilePathString.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "wandFile"));
        this.calibrate = ObjectManager.getManagedObjectFor(SoMFVec4f.class, SoTracker.getFieldHandle(this.getNativeResourceHandle(), "calibrate"));
    }

    static native String getClassTypeId();

    public SoTracker() {
        this(Inventor.ConstructorCommand.CreateInstance, SoTracker.ctorImplSync());
    }

    public SoTrackerReader getTrackerReader() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoTrackerReader soTrackerReader = ObjectManager.getManagedObjectFor(SoTrackerReader.class, SoTracker.getTrackerReaderImpl(this.getNativeResourceHandle()));
            return soTrackerReader;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoControllerReader getControllerReader() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoControllerReader soControllerReader = ObjectManager.getManagedObjectFor(SoControllerReader.class, SoTracker.getControllerReaderImpl(this.getNativeResourceHandle()));
            return soControllerReader;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

