/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.util;

import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.util.Scene;
import com.openinventor.util.SceneHandler;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;

public abstract class MultiScene
extends Panel
implements Scene {
    private Vector allScenes = new Vector();
    private int selection = -1;

    public MultiScene() {
    }

    public MultiScene(LayoutManager layoutManager) {
        super(layoutManager);
    }

    @Override
    public Component add(Component component) {
        Component component2 = super.add(component);
        if (component instanceof Scene) {
            this.addScene((Scene)((Object)component));
        }
        return component2;
    }

    @Override
    public Component add(Component component, int n) {
        Component component2 = super.add(component, n);
        if (component instanceof Scene) {
            this.addScene((Scene)((Object)component));
        }
        return component2;
    }

    @Override
    public Component add(String string, Component component) {
        Component component2 = super.add(string, component);
        if (component instanceof Scene) {
            this.addScene((Scene)((Object)component));
        }
        return component2;
    }

    @Override
    public void add(Component component, Object object) {
        super.add(component, object);
        if (component instanceof Scene) {
            this.addScene((Scene)((Object)component));
        }
    }

    @Override
    public void add(Component component, Object object, int n) {
        super.add(component, object, n);
        if (component instanceof Scene) {
            this.addScene((Scene)((Object)component));
        }
    }

    @Override
    public void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof Scene) {
            this.addScene((Scene)((Object)component));
        }
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        if (component instanceof Scene) {
            this.removeScene((Scene)((Object)component));
        }
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (component instanceof Scene) {
            this.removeScene((Scene)((Object)component));
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.removeAllScenes();
    }

    private void addScene(Scene scene) {
        if (scene == null) {
            return;
        }
        if (this.allScenes.indexOf(scene) < 0) {
            this.allScenes.addElement(scene);
        }
    }

    private void removeScene(Scene scene) {
        if (scene == null) {
            return;
        }
        this.allScenes.removeElement(scene);
    }

    private void removeAllScenes() {
        this.allScenes.removeAllElements();
    }

    public synchronized Enumeration getScenes() {
        return this.allScenes.elements();
    }

    public boolean contains(Scene scene) {
        return this.allScenes.contains(scene);
    }

    public int sceneNumber() {
        return this.allScenes.size();
    }

    public int indexOf(Scene scene) {
        return this.allScenes.indexOf(scene);
    }

    public Scene sceneAt(int n) {
        return (Scene)this.allScenes.elementAt(n);
    }

    public synchronized void select(int n) throws ArrayIndexOutOfBoundsException {
        int n2 = this.selection;
        if (n == -1 || this.allScenes.elementAt(n) != null) {
            this.selection = n;
        }
        if (this.selection != n2) {
            if (this.selection == -1) {
                this.setAllChanged();
                this.notifySceneHandlers();
            } else {
                Scene scene = this.getSelectedScene();
                scene.setAllChanged();
                scene.notifySceneHandlers();
            }
        }
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    public Scene getSelectedScene() {
        return this.selection != -1 ? (Scene)this.allScenes.elementAt(this.selection) : null;
    }

    @Override
    public void addSceneHandler(SceneHandler sceneHandler) {
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            ((Scene)enumeration.nextElement()).addSceneHandler(sceneHandler);
        }
    }

    @Override
    public void deleteSceneHandler(SceneHandler sceneHandler) {
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            ((Scene)enumeration.nextElement()).deleteSceneHandler(sceneHandler);
        }
    }

    @Override
    public void deleteSceneHandlers() {
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            ((Scene)enumeration.nextElement()).deleteSceneHandlers();
        }
    }

    @Override
    public void notifySceneHandlers() {
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            ((Scene)enumeration.nextElement()).notifySceneHandlers();
        }
    }

    @Override
    public void notifySceneHandlers(Object object) {
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            ((Scene)enumeration.nextElement()).notifySceneHandlers(object);
        }
    }

    @Override
    public boolean hasChanged() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.hasChanged();
        }
        boolean bl = false;
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            if (!(bl = bl || ((Scene)enumeration.nextElement()).hasChanged())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearChanged() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.clearChanged();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).clearChanged();
            }
        }
    }

    @Override
    public void setAllChanged() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setAllChanged();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setAllChanged();
            }
        }
    }

    @Override
    public boolean isDrawStyleUpdated() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isDrawStyleUpdated();
        }
        boolean bl = false;
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            if (!(bl = bl || ((Scene)enumeration.nextElement()).isDrawStyleUpdated())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBufferingTypeUpdated() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isBufferingTypeUpdated();
        }
        boolean bl = false;
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            if (!(bl = bl || ((Scene)enumeration.nextElement()).isBufferingTypeUpdated())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isViewingUpdated() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isViewingUpdated();
        }
        boolean bl = false;
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            if (!(bl = bl || ((Scene)enumeration.nextElement()).isViewingUpdated())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDrawStyle(int n, Scene.DrawStyle drawStyle) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setDrawStyle(n, drawStyle);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setDrawStyle(n, drawStyle);
            }
        }
    }

    @Override
    public Scene.DrawStyle getDrawStyle(int n) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getDrawStyle(n);
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getDrawStyle(n);
        }
        return Scene.DrawStyle.VIEW_AS_IS;
    }

    @Override
    public void setCurrentDrawStyle(Scene.DrawStyle drawStyle) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setCurrentDrawStyle(drawStyle);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setCurrentDrawStyle(drawStyle);
            }
        }
    }

    @Override
    public void setBufferingType(Scene.BufferType bufferType) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setBufferingType(bufferType);
        }
        Enumeration enumeration = this.getScenes();
        while (enumeration.hasMoreElements()) {
            ((Scene)enumeration.nextElement()).setBufferingType(bufferType);
        }
    }

    @Override
    public Scene.BufferType getBufferingType() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getBufferingType();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getBufferingType();
        }
        return Scene.BufferType.BUFFER_SINGLE;
    }

    @Override
    public void setDoubleBuffer(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setDoubleBuffer(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setDoubleBuffer(bl);
            }
        }
    }

    @Override
    public Scene.ViewingModes getMode() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getMode();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getMode();
        }
        return Scene.ViewingModes.VIEW_MODE;
    }

    @Override
    public void setMode(Scene.ViewingModes viewingModes, AWTEvent aWTEvent) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setMode(viewingModes, aWTEvent);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setMode(viewingModes, aWTEvent);
            }
        }
    }

    @Override
    public void viewAll() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.viewAll();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).viewAll();
            }
        }
    }

    @Override
    public void saveHomePosition() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.saveHomePosition();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).saveHomePosition();
            }
        }
    }

    @Override
    public void resetToHomePosition() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.resetToHomePosition();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).resetToHomePosition();
            }
        }
    }

    @Override
    public void setViewing(boolean bl, AWTEvent aWTEvent) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setViewing(bl, aWTEvent);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setViewing(bl, aWTEvent);
            }
        }
    }

    @Override
    public boolean isViewing() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isViewing();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).isViewing();
        }
        return false;
    }

    @Override
    public void setAnimationEnabled(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setAnimationEnabled(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setAnimationEnabled(bl);
            }
        }
    }

    @Override
    public boolean isAnimationEnabled() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isAnimationEnabled();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).isAnimationEnabled();
        }
        return false;
    }

    @Override
    public void setAnimating(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setAnimating(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setAnimating(bl);
            }
        }
    }

    @Override
    public boolean isAnimating() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isAnimating();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).isAnimating();
        }
        return false;
    }

    @Override
    public void stopAnimating() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.stopAnimating();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).stopAnimating();
            }
        }
    }

    @Override
    public void setSeekMode(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setSeekMode(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setSeekMode(bl);
            }
        }
    }

    @Override
    public boolean isSeekMode() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isSeekMode();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).isSeekMode();
        }
        return false;
    }

    @Override
    public void setTransparencyType(SoGLRenderAction.TransparencyTypes transparencyTypes) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setTransparencyType(transparencyTypes);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setTransparencyType(transparencyTypes);
            }
        }
    }

    @Override
    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getTransparencyType();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getTransparencyType();
        }
        return SoGLRenderAction.TransparencyTypes.SCREEN_DOOR;
    }

    @Override
    public void setAntialiasing(boolean bl, int n) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setAntialiasing(bl, n);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setAntialiasing(bl, n);
            }
        }
    }

    @Override
    public void setBackgroundIndex(int n) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setBackgroundIndex(n);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setBackgroundIndex(n);
            }
        }
    }

    @Override
    public int getBackgroundIndex() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getBackgroundIndex();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getBackgroundIndex();
        }
        return -1;
    }

    @Override
    public void setSize(Dimension dimension) {
        super.setSize(dimension);
    }

    @Override
    public Dimension getSize() {
        return super.getSize();
    }

    @Override
    public void setInteractiveFlag(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setInteractiveFlag(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setInteractiveFlag(bl);
            }
        }
    }

    @Override
    public boolean getInteractiveFlag() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getInteractiveFlag();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getInteractiveFlag();
        }
        return false;
    }

    @Override
    public void interactiveCountInc() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.interactiveCountInc();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).interactiveCountInc();
            }
        }
    }

    @Override
    public void interactiveCountDec() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.interactiveCountDec();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).interactiveCountDec();
            }
        }
    }

    @Override
    public int getInteractiveCount() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getInteractiveCount();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getInteractiveCount();
        }
        return -1;
    }

    @Override
    public void setAutoClipping(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setAutoClipping(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setAutoClipping(bl);
            }
        }
    }

    @Override
    public boolean isAutoClipping() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isAutoClipping();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).isAutoClipping();
        }
        return false;
    }

    @Override
    public void setStereoMode(int n) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setStereoMode(n);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setStereoMode(n);
            }
        }
    }

    @Override
    public void setStereoSwitch(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setStereoSwitch(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setStereoSwitch(bl);
            }
        }
    }

    @Override
    public int getStereoMode() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getStereoMode();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getStereoMode();
        }
        return 0;
    }

    @Override
    public boolean getStereoSwitch() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getStereoSwitch();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getStereoSwitch();
        }
        return false;
    }

    @Override
    public void setStereoOffset(float f) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setStereoOffset(f);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setStereoOffset(f);
            }
        }
    }

    @Override
    public float getStereoOffset() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getStereoOffset();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getStereoOffset();
        }
        return -1.0f;
    }

    @Override
    public void copyView(double d) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.copyView(d);
        }
    }

    @Override
    public void pasteView(double d) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.pasteView(d);
        }
    }

    @Override
    public void setClearBeforeRender(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setClearBeforeRender(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setClearBeforeRender(bl);
            }
        }
    }

    @Override
    public boolean isClearBeforeRender() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isClearBeforeRender();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).isClearBeforeRender();
        }
        return false;
    }

    @Override
    public void setAutoRedraw(boolean bl) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setAutoRedraw(bl);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setAutoRedraw(bl);
            }
        }
    }

    @Override
    public boolean isAutoRedraw() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.isAutoRedraw();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).isAutoRedraw();
        }
        return false;
    }

    @Override
    public void setRedrawPriority(long l) {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.setRedrawPriority(l);
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).setRedrawPriority(l);
            }
        }
    }

    @Override
    public long getRedrawPriority() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            return scene.getRedrawPriority();
        }
        if (this.sceneNumber() >= 1) {
            return this.sceneAt(0).getRedrawPriority();
        }
        return -1L;
    }

    @Override
    public void redraw() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.redraw();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).redraw();
            }
        }
    }

    @Override
    public void redrawOverlay() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.redrawOverlay();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).redrawOverlay();
            }
        }
    }

    @Override
    public void scheduleRedraw() {
        Scene scene = this.getSelectedScene();
        if (scene != null) {
            scene.scheduleRedraw();
        } else {
            Enumeration enumeration = this.getScenes();
            while (enumeration.hasMoreElements()) {
                ((Scene)enumeration.nextElement()).scheduleRedraw();
            }
        }
    }
}

