/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.converters;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.ldm.converters.SoBaseLDMConverter;
import com.openinventor.ldm.readers.SoVolumeReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;

public class SoVolumeConverter
extends SoBaseLDMConverter {
    private SoVolumeReader m_reader;
    private static Hashtable<Long, SoVolumeConverter> ConvertersTable = new Hashtable();

    private static long ctorImplSync(boolean bl) {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVolumeConverter.ctorImpl(bl);
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long ctorImpl(boolean var0);

    protected SoVolumeConverter(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public SoVolumeConverter() {
        this(false);
    }

    public SoVolumeConverter(boolean bl) {
        this(Inventor.ConstructorCommand.CreateInstance, SoVolumeConverter.ctorImplSync(bl));
        ConvertersTable.put(this.getNativeResourceHandle(), this);
    }

    protected void finalize() {
        ConvertersTable.remove(this.getNativeResourceHandle());
    }

    public void setReader(SoVolumeReader soVolumeReader) {
        this.m_reader = soVolumeReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sampleTile(SbVec3i32 sbVec3i32, int n, int n2, ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) {
        ObjectManager.globalLock.lock();
        try {
            SoVolumeConverter.sampleTileNativ(this.getNativeResourceHandle(), sbVec3i32.array, n, n2, byteBufferArray, byteBuffer);
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native void sampleTileNativ(long var0, int[] var2, int var3, int var4, ByteBuffer[] var5, ByteBuffer var6);

    private static void notifySampleTile(long l, int n, int n2, int n3, int n4, int n5, ByteBuffer[] byteBufferArray, ByteBuffer byteBuffer) {
        for (ByteBuffer byteBuffer2 : byteBufferArray) {
            if (byteBuffer2 == null) continue;
            byteBuffer2.order(ByteOrder.nativeOrder());
        }
        byteBuffer.order(ByteOrder.nativeOrder());
        SoVolumeConverter soVolumeConverter = ConvertersTable.get(new Long(l));
        try {
            soVolumeConverter.sampleTile(new SbVec3i32(n, n2, n3), n4, n5, byteBufferArray, byteBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean progress(int n, int n2) {
        return true;
    }

    private static boolean notifyProgress(long l, int n, int n2) {
        SoVolumeConverter soVolumeConverter = ConvertersTable.get(new Long(l));
        try {
            return soVolumeConverter.progress(n, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String getXmlTags() {
        return null;
    }

    private static String notifyGetXmlTags(long l) {
        SoVolumeConverter soVolumeConverter = ConvertersTable.get(new Long(l));
        try {
            return soVolumeConverter.getXmlTags();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private long getNativReader() {
        if (this.m_reader == null) {
            return ZeroHandle;
        }
        return this.m_reader.getNativeResourceHandle();
    }

    private static long notifyGetReader(long l) {
        SoVolumeConverter soVolumeConverter = ConvertersTable.get(new Long(l));
        try {
            return soVolumeConverter.getNativReader();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }
}

