/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFShort;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.ldm.SoLDMTileID;

public abstract class SoVolumeTransform
extends SoNode {
    public final SoSFShort volumeTransformId;
    public final SoSFInt32 cacheSize;

    private static native void getTransformedMinMaxImpl(long var0, double[] var2, double[] var3);

    private static native void addInCacheImpl(long var0, long var2, long var4);

    private static native long getFromCacheImpl(long var0, long var2);

    protected SoVolumeTransform(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.volumeTransformId = ObjectManager.getManagedObjectFor(SoSFShort.class, SoVolumeTransform.getFieldHandle(this.getNativeResourceHandle(), "volumeTransformId"));
        this.cacheSize = ObjectManager.getManagedObjectFor(SoSFInt32.class, SoVolumeTransform.getFieldHandle(this.getNativeResourceHandle(), "cacheSize"));
    }

    static native String getClassTypeId();

    public void addInCache(SoLDMTileID soLDMTileID, SoBufferObject soBufferObject) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeTransform.addInCacheImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public double[] getTransformedMinMax() {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVolumeTransform.getTransformedMinMaxImpl(this.getNativeResourceHandle(), dArray, dArray2);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        double[] dArray3 = new double[]{dArray[0], dArray2[0]};
        return dArray3;
    }

    public SoBufferObject getFromCache(SoLDMTileID soLDMTileID) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoBufferObject soBufferObject = ObjectManager.getManagedObjectFor(SoBufferObject.class, SoVolumeTransform.getFromCacheImpl(this.getNativeResourceHandle(), soLDMTileID != null ? soLDMTileID.getNativeResourceHandle() : Inventor.ZeroHandle));
            return soBufferObject;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }
}

