/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.volumeviz.readers;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.volumeviz.readers.dicom.SiDicomDataSet;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SoVRDicomData
extends Inventor {
    private static native float getXPixelSizeImpl(long var0);

    private static native int getImageHeightImpl(long var0);

    private static native float getSliceLocationImpl(long var0);

    private static native int getSizeInBytesImpl(long var0);

    private static native boolean getPositionImpl(long var0, float[] var2);

    private static native int getNumFramesImpl(long var0);

    private static native float getYPixelSizeImpl(long var0);

    private static native int getImageWidthImpl(long var0);

    private static native int getBytesPerPixelImpl(long var0);

    private static native Object getImageImpl(long var0);

    private static native float getSliceSpacingImpl(long var0);

    private static native float getSliceThicknessMMImpl(long var0);

    private static native int getSamplesPerPixelImpl(long var0);

    private static native int getImageNumberImpl(long var0);

    private static native boolean supportedTransferSyntaxImpl(long var0);

    private static native int getSeriesNumberImpl(long var0);

    private static native void getImagePositionImpl(long var0, float[] var2);

    private static native float getSlopeImpl(long var0);

    private static native long ctorImpl();

    private static native float getInterceptImpl(long var0);

    private static long ctorImplSync() {
        ObjectManager.globalLock.lock();
        try {
            long l = SoVRDicomData.ctorImpl();
            return l;
        }
        finally {
            ObjectManager.globalLock.unlock();
        }
    }

    private static native long getDicomDataSetImpl(long var0);

    private static native String getDicomInfoImpl(long var0, short var2, short var3);

    private static native int getBitsStoredImpl(long var0);

    private static native boolean closeImpl(long var0);

    private static native boolean getOrientationImpl(long var0, float[] var2);

    private static native boolean readDicomHeaderImpl1(long var0, String var2);

    private static native int signedDataImpl(long var0);

    private static native boolean readDicomImageImpl(long var0, String var2);

    private static native int getHighBitImpl(long var0);

    protected SoVRDicomData(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public int signedData() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.signedDataImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getHighBit() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getHighBitImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean readDicomImage(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVRDicomData.readDicomImageImpl(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbMatrix getOrientation() {
        SbMatrix sbMatrix = new SbMatrix();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVRDicomData.getOrientationImpl(this.getNativeResourceHandle(), sbMatrix != null ? sbMatrix.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbMatrix;
        }
        return null;
    }

    public boolean close() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVRDicomData.closeImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getBitsStored() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getBitsStoredImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDicomInfo(short s, short s2) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            String string = SoVRDicomData.getDicomInfoImpl(this.getNativeResourceHandle(), s, s2);
            return string;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SoVRDicomData() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVRDicomData.ctorImplSync());
    }

    public SiDicomDataSet getDicomDataSet() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            SiDicomDataSet siDicomDataSet = ObjectManager.getManagedObjectFor(SiDicomDataSet.class, SoVRDicomData.getDicomDataSetImpl(this.getNativeResourceHandle()));
            return siDicomDataSet;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getSlope() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoVRDicomData.getSlopeImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean readDicomHeader(String string) {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVRDicomData.readDicomHeaderImpl1(this.getNativeResourceHandle(), string);
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getIntercept() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoVRDicomData.getInterceptImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getImageNumber() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getImageNumberImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public boolean supportedTransferSyntax() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            boolean bl = SoVRDicomData.supportedTransferSyntaxImpl(this.getNativeResourceHandle());
            return bl;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getSliceLocation() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoVRDicomData.getSliceLocationImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getSamplesPerPixel() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getSamplesPerPixelImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getSeriesNumber() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getSeriesNumberImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getSliceThicknessMM() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoVRDicomData.getSliceThicknessMMImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    @Deprecated
    public ByteBuffer getImage() {
        ByteBuffer byteBuffer = null;
        this.acquireLock(ObjectManager.globalLock);
        try {
            byteBuffer = (ByteBuffer)SoVRDicomData.getImageImpl(this.getNativeResourceHandle());
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asReadOnlyBuffer();
    }

    public float getSliceSpacing() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoVRDicomData.getSliceSpacingImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getImageWidth() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getImageWidthImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f getPosition() {
        SbVec3f sbVec3f = new SbVec3f();
        boolean bl = false;
        this.acquireLock(ObjectManager.globalLock);
        try {
            bl = SoVRDicomData.getPositionImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        if (bl) {
            return sbVec3f;
        }
        return null;
    }

    public int getNumFrames() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getNumFramesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public SbVec3f getImagePosition() {
        SbVec3f sbVec3f = new SbVec3f();
        this.acquireLock(ObjectManager.globalLock);
        try {
            SoVRDicomData.getImagePositionImpl(this.getNativeResourceHandle(), sbVec3f.array);
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
        return sbVec3f;
    }

    public int getImageHeight() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getImageHeightImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getXPixelSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoVRDicomData.getXPixelSizeImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getBytesPerPixel() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getBytesPerPixelImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public float getYPixelSize() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            float f = SoVRDicomData.getYPixelSizeImpl(this.getNativeResourceHandle());
            return f;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    public int getSizeInBytes() {
        this.acquireLock(ObjectManager.globalLock);
        try {
            int n = SoVRDicomData.getSizeInBytesImpl(this.getNativeResourceHandle());
            return n;
        }
        finally {
            this.releaseLock(ObjectManager.globalLock);
        }
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            ObjectManager.globalLock.lock();
            try {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }
            finally {
                ObjectManager.globalLock.unlock();
            }
        }
    }
}

